#ifndef MARS_MDataChain
#define MARS_MDataChain

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//  MDataList                                                              //
//                                                                         //
//  List of several filters                                                //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MData
#include "MData.h"
#endif

class MDataChain : public MData
{
private:
    MData *fMember; // Filter

    typedef enum {
        kENoop,
        kELog10,
        kELog,
        kEAbs,
        kESin,
        kECos,
        kETan,
        kESinH,
        kECosH,
        kETanH,
        kEASin,
        kEACos,
        kEATan,
        kESqrt,
        kEPow10,
        kEExp
    } OperatorType_t;

    OperatorType_t fOperatorType;

    OperatorType_t ParseOperator(TString txt) const;

    Int_t IsAlNum(TString txt);
    Int_t GetBracket(TString txt);

    MData *ParseString(TString txt, Int_t level);

    MDataChain(const char *rule, OperatorType_t op);

public:
    MDataChain(const char *rule, const char *name=NULL, const char *title=NULL);
    ~MDataChain();

    Double_t GetValue() const;
    Bool_t PreProcess(const MParList *plist);

    Bool_t IsValid() const { return fMember ? kTRUE : kFALSE; }

    void Print(Option_t *opt = "") const;

    ClassDef(MDataChain, 0) // A chain/concatenation of MData objects
};

#endif
