#ifndef MARS_MFDataMember
#define MARS_MFDataMember

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFDataMember                                                                 //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif
#ifndef MARS_MDataMember
#include "MDataMember.h"
#endif

class MParList;

class MFDataMember : public MFilter
{
private:
    MDataMember fData;

    typedef enum { kELowerThan, kEGreaterThan } FilterType_t;
    FilterType_t fFilterType;

    Bool_t  fResult;
    Double_t fValue;

public:
    MFDataMember(const char *member, const char type, const Double_t val,
                 const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }
    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    void Print(Option_t *opt = "") const;

    ClassDef(MFDataMember, 0) // A Filter for cuts in any data member
};

#endif
