# Program to calculate integral deviation for several Datasets
#
# Remo Dietlicher
# ETH Zrich
# Semesterarbeit
#
#

import pyfact
from myhisto import *
from hist import *
import numpy as np
import numpy.random as rnd
from scipy import interpolate as ip
from ROOT import *
from time import time
from optparse import OptionParser
from ftcal2 import ftcal
from periods2 import periods2


NROI = 1024				# Region of interest
NChip = 2				# Number of Chips
NEvents = 400			# Number of Events
fsampling = 1024./512. 	# sampling frequency

# Open default Datafiles

Datafiles = []

Datafiles.append(["/data00/fact-construction/raw/2011/11/24/20111124_014.fits.gz",
				  "/data00/fact-construction/raw/2011/11/24/20111124_012.drs.fits.gz"])
				  
Datafiles.append(["/data00/fact-construction/raw/2011/11/24/20111124_034.fits.gz",
				  "/data00/fact-construction/raw/2011/11/24/20111124_032.drs.fits.gz"])			  
				  
Datafiles.append(["/data00/fact-construction/raw/2011/11/24/20111124_053.fits.gz",
				  "/data00/fact-construction/raw/2011/11/24/20111124_051.drs.fits.gz"])
				  
Datafiles.append(["/data00/fact-construction/raw/2011/11/24/20111124_073.fits.gz",
				  "/data00/fact-construction/raw/2011/11/24/20111124_071.drs.fits.gz"])
				  
Datafiles.append(["/data00/fact-construction/raw/2011/11/24/20111124_093.fits.gz",
				  "/data00/fact-construction/raw/2011/11/24/20111124_091.drs.fits.gz"])
				  
Datafiles.append(["/data00/fact-construction/raw/2011/11/24/20111124_113.fits.gz",
				  "/data00/fact-construction/raw/2011/11/24/20111124_111.drs.fits.gz"])
				
				  
count = 6

h = range(count)

for dat in range(count):
	h[dat] = hist_list(ftcalappHistograms, NChip, "Chip")

# Parser for extended Version

parser = OptionParser()
parser.add_option('-e', '--extended', action = 'store_true', dest='extend', default = False )
(options, args) = parser.parse_args()

path = "/data00/fact-construction/raw/"


# Open any Datafile

if(options.extend):

	Datafiles = []
	
	year = raw_input("Daten aus welchem Jahr? ")
	month = raw_input("Daten aus welchem Monat? ")
	day = raw_input("Daten von welchem Tag? ")
	path = "/data00/fact-construction/raw/"+str(year)+"/"+str(month)+"/"+str(day)+"/"
	
	count = int(raw_input("Wieviele runs? "))
	h = range(count)
	
	
	for dat in range(count):
		run = year+month+day+"_"+raw_input("Welcher Datenrun? ")+".fits.gz"
		drs = year+month+day+"_"+raw_input("Welcher Kalibrationsrun? ")+".drs.fits.gz"
		Datafiles.append([str(path)+str(run), str(path)+str(drs)])
		h[dat] = hist_list(ftcalappHistograms, NChip, "Chip")
		

	NChip = int(raw_input("Wieviele Chips? ([1, ... ,160]): "))
	NEvents = int(raw_input("Wieviele Events? ([1, ... , 1000]) "))


save = raw_input("Sollen die Kalibrationskonstanten Gespeichert weden? (yes/no) ")		
	
	
	
		
CellTime = np.zeros([count, NChip, NROI+1])
DataMean = np.zeros([count, NChip, NROI])
		
for dat in range(count):
	print "Datafile: ", Datafiles[dat][0]
	CellTime[dat], DataMean[dat] = ftcal(NChip, NEvents, h[dat], Datafiles[dat][0], Datafiles[dat][1])

for dat in range(count):
	for Chip in range(NChip):
		for i in range(NROI):
			h[dat].list[Chip].dict["int_dev"].SetBinContent(i+1, CellTime[dat][Chip][i]-i/fsampling)
			
		periods2(DataMean[dat][Chip], CellTime[dat][Chip], h[dat].list[Chip])
			
			
	pyfact.SaveHistograms(h[dat].list, str(Datafiles[dat][0][-20:-8])+"_"+str(NEvents)+"x"+str(NChip)+".root", "RECREATE")
	
	
	print "Histogram saved as: ", str(Datafiles[dat][0][-20:-8])+"_"+str(NEvents)+"x"+str(NChip)+".root"
			
	

if(save == "yes"):
	for dat in range(count):
		np.save("FtcalKonst/"+str(Datafiles[dat][0][-20:-8])+"_"+str(NEvents)+"x"+str(NChip), CellTime[dat])
		print "calibration constants saved as: ", str(Datafiles[dat][0][-20:-8])+"_"+str(NEvents)+"x"+str(NChip)+".npy"


































