# Programm zur Jitter-Bestimmung
#
#
# Remo Dietlicher
# ETH Zrich
#
#


import pyfact
from myhisto import *
from hist import *
import numpy as np
import numpy.random as rnd
from scipy import interpolate as ip
from ROOT import *
from time import time
from optparse import OptionParser

jitterSummary = jitterHistograms( "jitter" )


Data0 = np.loadtxt("20120106T162310_ch0.txt")

NEvents, NROI = np.shape(Data0)

Start0 = np.loadtxt("20120106T162310_start_ch0.txt")

Data8 = np.loadtxt("20120106T162310_ch8.txt")

Start8 = np.loadtxt("20120106T162310_start_ch8.txt")

for i in range(NROI):
	jitterSummary.dict["data0"].SetBinContent(i+1, Data0[10][i])
	jitterSummary.dict["data8"].SetBinContent(i+1, Data8[10][i])

Thresh = 250

#rCellTime = np.load("Remo_dat_1000x15123.npy")
rCellTime = np.load("CellTimeOliver.npy")


def Crossing(Data):

	TimeXing = "gugus"
	CellTime = np.roll(rCellTime, -int(Start0[Event][0]))

	for i in range(NROI-1):

		if((Data[i] < Thresh) & (Data[i+1] > Thresh) & (Data[np.mod(i+300, NROI)] > Thresh)):

			FirstCell = CellTime[i]
			SecondCell = CellTime[i+1]

			TimeXing = FirstCell+(SecondCell-FirstCell)/(1.-Data[i+1]/(Data[i]))*(1.-Thresh/(Data[i]))

	return TimeXing

Diff = np.zeros(NEvents)

count = 0

for Event in range(NEvents):
	print Event

	Time0 = Crossing(Data0[Event])
	Time8 = Crossing(Data8[Event])

	if((Time0 == "gugus") or (Time8 == "gugus")):
		count += 1
		continue

	Diff[Event] = Time0 - Time8
	jitterSummary.dict["diff"].Fill(Diff[Event])

pyfact.SaveHistograms([jitterSummary], "Jitter_Histo_Oliver.root", "RECREATE")

print "Number of skipped events: ", count
print "Histo saved as	= ", "Jitter_Histo.root"



	




























	
	
	
