# Programm zur Bestimmung der Genauigkeit des konvergierten Algorithmus
#
# Remo Dietlicher
#
#

from optparse import OptionParser
import pyfact
from myhisto import *
from hist import *
import numpy as np
import numpy.random as rnd
from ROOT import *
from time import time

def periods2(Data, CellTime, h):

	NROI  = 1024 				# length of the DRS pipeline
	fsampling = 2. 				# sampling frequency
	freq = 250.        			# testfrequency
	P_nom = 1000./freq 			# nominal Period due to testfrequency


	nomCellTime = np.linspace(0., 1024., 1025)/fsampling


	# FUNCTION TO DETERMINE CROSSINGS

	def Crossing(Mean, rCellTime):
		TimeXing = np.zeros(NROI)
		MeanXing = np.zeros(NROI)
		NumXing = 0

		for i in range(NROI-1):
			if ((Data[i] > Mean) & (Data[i+1] < Mean)):
				MeanXing[NumXing] = i

				FirstCell = rCellTime[i]
				SecondCell = rCellTime[i+1]

				TimeXing[NumXing] = FirstCell+(SecondCell-FirstCell)/(1.-Data[i+1]/(Data[i]))*(1.-Mean/(Data[i]))
				NumXing += 1

		return MeanXing, TimeXing

	def CalculatePeriods(rCellTime, name):

		Period = np.zeros(126)

		MeanXing, TimeXing = Crossing(np.average(Data), rCellTime)

		for i in range(int(126)):
			Period[i] = TimeXing[i+1] - TimeXing[i]

		for val in Period:
			h.dict[str(name)].Fill(val)

		return

	CalculatePeriods(CellTime, "avperiods")
	CalculatePeriods(nomCellTime, "avperiods0")
	
	return




