#!/usr/bin/python -itt

##############################################
# by Q. Weitzel and T. Kraehenbuehl
# plot trigger rates for all runs of one night
# adapt base_path to select the night
# (and change title and zoom of the graph)
##############################################

from array import array
import os
import re

from factfits import FactFits

from ROOT import TCanvas, TGraph
from ROOT import gROOT
from ROOT import gStyle

gROOT.SetStyle("Plain")

filelist = []
base_path = "/fact/aux/2012/04/16/"

for base,subdirs,files in os.walk(base_path):
    for filename in files:
        #include only run files
        regex = re.search(r'_\d\d\d\.FTM_CONTROL_TRIGGER_RATES',filename)
        #include run files and also the nightly file
        #regex = re.search(r'FTM_CONTROL_TRIGGER_RATES',filename)
        if regex:
            filelist.append(os.path.join(base,filename))

#alternatively, select slow data files directly for the file list
#filelist = ["/fact/aux/2012/04/16/20120416_030.FTM_CONTROL_TRIGGER_RATES.fits",
#            "/fact/aux/2012/04/16/20120416_040.FTM_CONTROL_TRIGGER_RATES.fits"]

trigger_rate_array = array("d",[])
time_array = array("d",[])

for filename in filelist:

    print filename

    file_handle = FactFits(filename)

    file_handle.register("TriggerRate")
    file_handle.register("Time")
    file_handle.register("FTMtimeStamp")

    ftm_ts_old = 1E10

    for row in file_handle:
        if row.FTMtimeStamp>ftm_ts_old:#needed to remove negative rate in first report
            trigger_rate_array.append(float(row.TriggerRate))
            time_array.append(float(row.Time)*24*3600)
        ftm_ts_old = row.FTMtimeStamp

canv = TCanvas("canv","title",50,50,1500,800)
graph = TGraph(len(trigger_rate_array),time_array,trigger_rate_array)

#change the time format to human readable
graph.GetXaxis().SetTimeDisplay(1);
#graph.GetXaxis().SetTimeFormat("%d.%m.  %H:%M%F1970-01-01 00:00:00");
graph.GetXaxis().SetTimeFormat("%H:%M%F1970-01-01 00:00:00")

graph.SetMarkerStyle(7)
graph.SetMarkerSize(1)
graph.SetMarkerColor(2)
graph.SetTitle("Night 16.04.2012")
graph.GetYaxis().SetRangeUser(0,250)#zoom to be adapted for each night
graph.GetXaxis().SetTitleOffset(1.2)
graph.GetXaxis().SetTitle("UTC+4h  (hh:mm)")#for summer time
graph.GetYaxis().SetTitle("Trigger Rate (Hz)")
graph.Draw("ap")
