#!/usr/bin/python -itt
#
# Dominik Neise
#
# tiny script 
from pyfact import RawData
import os.path
import matplotlib.pyplot as plt
import numpy as np
from fir_filter import *
from extractor import *
from drs_spikes import *
from plotters import *
import time as t
confirm_next_step = True # this is for user interaction

data_file_name = '/media/daten_platte/FACT/data/20120229_144.fits.gz'
calib_file_name = '/media/daten_platte/FACT/data/20120229_132.drs.fits.gz'
if not os.path.isfile(data_file_name):
    print 'not able to find file:', data_file_name
    sys.exit(-1)
if not os.path.isfile(calib_file_name ):
    print 'not able to find file:', calib_file_name 
    sys.exit(-1)

run = RawData(data_file_name, calib_file_name)
despike = DRSSpikes()
plot = Plotter('-to-be-changed')

ts = []
dts = []
t = None
dt = None
t0 = None
run = run +170
for data,startcell,tt in run:
    print run.event_id.value
    if t0==None:
        t0 = np.copy(run.board_times)
    t = np.mean(run.board_times - t0)
    ts.append(t)
    if len(ts) > 1:
        dt = ts[-1] - ts[-2]
        dts.append(dt)
    
    if not dt==None and dt < 5:
        print 'dt=',dt
        despike(data)
        plot.name = '20120229_144 event:' + str(run.event_id.value) + ' TT:' + str(tt)
        plot.fname = '20120229_144_' + str(run.event_id.value) +'.png'
        plot(data)
        raw_input('<Enter>?')
    
    
