#!/usr/bin/python -itt
#
# Dominik Neise
#
# cleaning a small step towards the truth
from pyfact import RawData
import os.path
import matplotlib.pyplot as plt
import numpy as np
from fir_filter import *
from extractor import *
from drs_spikes import *
from plotters import *
import time as t
from cleaners import AmplitudeCleaner
from image_extractors import SimpleArea, SimpleSize
confirm_next_step = False# this is for user interaction

data_file_name = 'data/20120223_212.fits.gz'
calib_file_name = 'data/20120223_206.drs.fits.gz'
if not os.path.isfile(data_file_name):
    print 'not able to find file:', data_file_name
    sys.exit(-1)
if not os.path.isfile(calib_file_name ):
    print 'not able to find file:', calib_file_name 
    sys.exit(-1)

run = RawData(data_file_name, calib_file_name)
despike = DRSSpikes()
smooth = SlidingAverage(8)
extract = GlobalMaxFinder(40,200)
cleaner = AmplitudeCleaner(45,18)
area = SimpleArea()
size = SimpleSize()

#plotA = CamPlotter('amplitudes')
#plotT = CamPlotter('times')
#plotCA = CamPlotter('cleaned amplitudes')

#plotArea = HistPlotter('area', 1440, (0,1440) )
#plotSize = HistPlotter('size', 1000, (0,10000) )


areas = []
sizes = []
for data,startcell,tt in run:
    # trigger type 4 means 'physics event'
    if tt==4:
        data = despike(data)
        data = smooth(data)
        amplitude, time_of_max = extract(data)
        survivors = cleaner(amplitude, return_bool_mask=False )
        areas.append( area(survivors) )
        sizes.append( size(survivors, amplitude) )

        if confirm_next_step:
            user_input = raw_input("'q'-quit, 'r'-run, anything else goes one step")
            number=None
            try:
                number=int(user_input)
            except:
                number=None
            if user_input.find('q') != -1:
                sys.exit(0)
            elif user_input.find('r') != -1:
                confirm_next_step = False
            elif number!=None:
                run += number


plt.ion()
myfig = plt.figure()
myn = myfig.number
logsize = np.log10(np.array(sizes))
areas = np.array(areas)

plt.figure(myn)
plt.title('area vs. log10(size) of '+ str(run.event_id.value) + 'events')
plt.xlabel('log10(size/1mV)')
plt.ylabel('area [#pixel]')
plt.plot( logsize,areas, '.')
