// file zerosearch.h
#ifndef __ZEROSEARCH_H
#define __ZEROSEARCH_H

#include "Region.h"

vector<Region> *zerosearch(
    vector<float> &input,
    int edge = 1,			// search for transitions on rising edge=1, -1:falling
    unsigned int step = 4,			// search in steps of step
    int VerbosityLevel = 1  // 1 means ... just normal warings are output.
);

size_t ShiftRegionBy(vector<Region> &src,
    int Shift,
    int VerbosityLevel=0);

size_t EnlargeRegion(vector<Region> &src,
    int Left,
    int Right,
    int VerbosityLevel=0);

size_t findAbsMaxInRegions(
    vector<Region> &regions,
    vector<float> &data,
    int VerbosityLevel=0);

bool compMaxPosOfRegions (Region a, Region b);

size_t removeEqualMaxima(
    vector<Region> &regions,
    int VerbosityLevel=0);

size_t removeRegionOnFallingEdge(
  vector<Region> &regions,
  unsigned int FallingEdgeWidth = 100,
  int VerbosityLevel=0);


size_t removeRegionWithMaxOnEdge(
    vector<Region> &regions,
    unsigned int EdgeWidth=3,
    int VerbosityLevel=0);

size_t removeMaximaBelow(
    vector<Region> &regions,
    float threshold = 2.0,
    int VerbosityLevel=0);

size_t removeMaximaAbove(
    vector<Region> &regions,
    float threshold= 14.0,
    int VerbosityLevel=0);

Region FindAbsMax(
   vector<Region> &regions,
   int VerbosityLevel=0);

size_t findTimeOfHalfMaxLeft(
    vector<Region> &regions,
    vector<float> &data,
    float baseline = -0.5,
    int beginRisingEdge = 5,
    int endRisingEdge = 10,
    int VerbosityLevel = 1);


#endif
