#ifndef __SLICECALCULATION_H
#define __SLICECALCULATION_H

Double_t
MedianOfH1(
        TH1*            h1,
        int             verbosityLevel
        );

void
PlotMedianEachSliceOfPulse(
        TH2*            phInputHistogram,
        TH1*            phOutputHistogram,
        int             fitdata,
        int             verbosityLevel
        );

//compute the mean for each slice of a given TH2 histogram
void
PlotMeanEachSliceOfPulse(
        TH2*            phInputHistogram,
        TH1*            phOutputHistogram ,
        int             fitdata,
        int             verbosityLevel
        )

void
FitMaxPropabilityPuls(
        TH1*           phInputHistogram,
        float           left_border=-50,
        float           right_border=250,
        int             verbosityLevel
        )

#endif // SLICECALCULATION_H
