#!/usr/bin/python -tt
# ********************************
# Test script for the CalFits class
# 
# written by Thomas Kraehenbuehl, ETH Zurich
# tpk@phys.ethz.ch, +41 44 633 3973
# April 2012
# ********************************

datafilename = '/fact/raw/2012/04/17/20120417_004.fits.gz'
calibfilename = '/fact/raw/2012/04/17/20120417_003.drs.fits.gz'

import numpy as np

from ROOT import gSystem
gSystem.Load("calfits_h.so")
from ROOT import *
print "Testing object creation: "
caltest = CalFits(datafilename,calibfilename)
npcalevent  = np.empty( caltest.npix * caltest.nroi, np.float64) #.reshape(caltest.npix ,caltest.nroi)
caltest.SetNpcaldataPtr(npcalevent)

print "Common variables:"
print "ROI: ", caltest.nroi
print "#Pix: ", caltest.npix
print "Number of events: ", caltest.nevents
print

print "Information per Event:"
caltest.GetCalEvent()
print "Event ID: ", caltest.event_id
print "Trigger type: ", caltest.event_triggertype
print "Uncalibrated data: ", caltest.event_data
print "Calibrated data: ", caltest.npcaldata
print "Board times: ", caltest.event_boardtimes
print "Trigger offsets: ", caltest.event_offset
print

print "Examples of other information"
print "Calibfile ROI: ", caltest.calib_nroi
print "Column size BaselineMean: ", caltest.calibfile.GetN("BaselineMean")
print "Datafile ROI: ", caltest.data_nroi
print "Data: ", caltest.datafile.GetN("Data")
print "StartCellData: ", caltest.datafile.GetN("StartCellData")
print "Direct datafile access: ", caltest.datafile.GetN("StartCellData")
print
print "Columns of the datafile: "
caltest.datafile.PrintColumns()

#while caltest.GetCalEvent():
#    if caltest.event_id>10:
#        break
#    print caltest.event_id, caltest.event_triggertype, caltest.event_caldata[10]
#    pass
#print

del caltest
