#!/usr/bin/python -tti
#
# 

from pyfact   import RawData
from drs_spikes import DRSSpikes        
from fir_filter import CFD
from fir_filter import SlidingAverage

from plotters import Plotter

import sys
import cPickle
import matplotlib.pyplot as plt
import numpy as np

data_filename = 'data/20111017_009.fits.gz'
calib_filename = 'data/20111017_006.drs.fits.gz'
out_filename = 'test.pkl'

run = RawData(data_filename, calib_filename, return_dict = True, do_calibration=True)
despike = DRSSpikes()
smooth = SlidingAverage(7)
cfd = CFD()

thr = 3
filter_delay = 3

plt.ion()
fig = plt.figure()
fig.hold(True)


for event in run:
    print event['event_id'].value
    data = event['acal_data']
    data = despike(data)
    data_orig = data.copy()
    data = smooth(data)
    filtered = cfd(data)
    filtered = smooth(filtered)

    for dat, fil, orig in zip(data, filtered, data_orig):
        plt.cla()
        prod = fil[:-1] * fil[1:]
        cand = np.where( prod <= 0)[0]
        # zero crossing with rising edge
        cross = cand[np.where(fil[cand] < 0)[0]]
        
        over_thr = cross[np.where(dat[cross-4] > thr)[0]]

        # Now we have these values, we will throw away all those,
        # which are probably on a falling edge of its predecessor
        
        
        over = []
        dover = np.diff(over_thr)
        
        for i in range(len(over_thr)):
            if dover[i] > 100:
                
                
        over_thr = np.array(over)
        # these positions, we just found, do not exactly point to the maximum
        # of a peak, but the peak will be on the left side of it.
        # we use the smoothed data to find the position of the local maximum
        # and then stopre this position and the value of both
        # the smoothed data and the original data.
        
        max_pos      = np.zeros( over_thr.shape )
        max_smoothed = np.zeros( over_thr.shape )
        max_orig     = np.zeros( over_thr.shape )
    
        for i in range(len(over_thr)):
            # We search for a local maximum in a window of size 12
            if len(dat[over_thr[i]-12:over_thr[i]]) > 0:
            
                max_pos[i]       = over_thr[i]-12 + np.argmax(dat[over_thr[i]-12:over_thr[i]])
                max_smoothed[i]  = dat[max_pos[i]]
                max_orig[i]       = orig[max_pos[i]-filter_delay]

        plt.plot(max_pos, max_smoothed, 'ro')
        plt.plot(max_pos, max_orig, 'bo')
        plt.plot(np.arange(len(dat)), dat, 'k:')
        
        raw_input('bla')


#output = open(out_filename, 'wb')
#cPickle.dump(data_filename, output, -1)
#cPickle.dump(calib_filename, output, -1)
#cPickle.dump(peak_list, output, -1)
