#!/usr/bin/python -tti
#
# 

from pyfact   import RawData
from drs_spikes import DRSSpikes        
from fir_filter import CFD
from extractor import ZeroXing
from fir_filter import SlidingAverage

from plotters import Plotter

import sys
import cPickle
import matplotlib.pyplot as plt
import numpy as np

data_filename = 'data/20111017_009.fits.gz
calib_filename = 'data/20111017_006.drs.fits.gz'
out_filename = 'test.pkl'

run = RawData(data_filename, calib_filename, return_dict = True, do_calibration=True)
despike = DRSSpikes()
smooth = SlidingAverage(7)
cfd = CFD()
find = ZeroXing()

plt.ion()

peak_list = []
        
#p = Plotter('data[0]')


#fig = plt.figure()
#plt.grid(True)

stupid_list = []
thr = 3

fig = plt.figure()
fig.hold(True)

for event in run:
    print event['event_id'].value
    data = event['acal_data']
    origorig = data.copy()
    data = despike(data)
    data_orig = data.copy()
    data = smooth(data)
    filtered = cfd(data)
    filtered = smooth(filtered)

    for dat, fil, orig, zzz in zip(data, filtered, data_orig, origorig):
        plt.cla()
        prod = fil[:-1] * fil[1:]
        cand = np.where( prod <= 0)[0]
        # zero crossing with rising edge
        cross = cand[np.where(fil[cand] < 0)[0]]
        
        over_thr = cross[np.where(dat[cross-4] > thr)[0]]

        maxima = np.zeros( over_thr.shape )
        maxima_pos =np.zeros( over_thr.shape )
        omaxima = np.zeros( over_thr.shape )
        omaxima_pos =np.zeros( over_thr.shape )
        
        for i in range(len(over_thr)):
            if len(dat[over_thr[i]-12:over_thr[i]]) > 0:
                maxima_pos[i] = over_thr[i]-12 + np.argmax(dat[over_thr[i]-12:over_thr[i]])
                maxima[i]     = dat[maxima_pos[i]]
                omaxima_pos[i] = over_thr[i]-12 + np.argmax(orig[over_thr[i]-12:over_thr[i]])
                omaxima[i]     = orig[maxima_pos[i]-3]

        x_values = np.array(range(len(dat)))

        plt.plot( x_values-3, dat , 'k:')
        plt.plot( x_values, orig , 'y:')
        plt.plot( x_values, zzz , 'r.')
        
        plt.plot( maxima_pos-3, maxima, 'bo')
        plt.plot( maxima_pos-3, omaxima, 'yo')
        plt.plot( over_thr-3, dat[over_thr], 'ro')
            
        

        ret = raw_input('quit?')
        if ret=='q':
            break

#    peak_list.append( good_peaks )


#output = open(out_filename, 'wb')
#cPickle.dump(data_filename, output, -1)
#cPickle.dump(calib_filename, output, -1)
#cPickle.dump(peak_list, output, -1)
