#!/usr/bin/python -tti
#
# 

import sys
import numpy as np
import matplotlib.pyplot as plt

if len(sys.argv) > 1:
    npz_file = np.load(sys.argv[1])
else:
    print 'I need a filename'
    sys.exit(0)

print npz_file.files

# sanitiy check for gain npz files
# 
expected_filenames = [
    'result_peak_positions',
    'result_peak_unfiltered_height',
    'result_peak_smoothed_height']

abort = False
for fn in expected_filenames:
    if not fn in npz_file.files:
        print 'coulnd not find', fn, 'in ', sys.argv[1]
        print 'This is probably no gain-npz-file ...'
        print 'Aborting...'
        abort = True
if abort:
    print npz_file.files
    sys.exit(1)

data = npz_file['result_peak_smoothed_height']
data = np.nan_to_num(data)

plt.ion()
fig = plt.figure()

for i in range(data.shape[1]): # this is a loop over a pixel
    plt.cla()
    plt.grid(True)
    plt.title('Pixel ' + str(i))
    plt.xlabel('darc count amplitude mV')
    plt.ylabel('rate')
    contents,bins,patches = plt.hist(data[:,i,:].flatten(), range=(0,100), bins=200, align='left', histtype='step')
    #break
    raw_input('')
