#include "pixel.h" // class implemented
using namespace std;

/////////////////////////////// PUBLIC ///////////////////////////////////////

//============================= LIFECYCLE ====================================

//Pixel::Pixel(int pixelID)
//{
//    Chid                                = pixelID;
//    max_puslse_order                    = 1;
//    hMaxOverlay                       = NULL;
//    hEdgeOverlay                   = NULL;
//    hMaxProfile                       = NULL;
//    hEdgeProfile                      = NULL;
//    hList                               = NULL;

//}

Pixel::Pixel(
        int         pixelID         = 0,
        int         maxPulsorder    = 1,
        int         verbosityLevel  = 0,
        int         pixelOverlayXaxisLeft,
        int         pixelOverlayXaxisRight,
        int         bSLMean,
        int         gainMean,
        const char* options         = "",
        )
{
    mChid                   = pixelID;
    mMaxPulseOrder          = maxPulsorder;
    mVerbosityLevel         = verbosityLevel;
    mOptions                = options;
    mPixelOverlayXaxisLeft  = pixelOverlayXaxisLeft;
    mPixelOverlayXaxisRight = pixelOverlayXaxisRight;
    mBSLMean                = bSLMean;
    mGainMean               = gainMean;

    hMaxOverlay     = (TH2F*) calloc(mMaxPulseOrder, sizeof(TH2F));
    hEdgeOverlay    = (TH2F*) calloc(mMaxPulseOrder, sizeof(TH2F));
    hMaxProfile     = (TProfile*) calloc(mMaxPulseOrder, sizeof(TProfile));
    hEdgeProfile    = (TProfile*) calloc(mMaxPulseOrder, sizeof(TProfile));

    if (mOptions == "S")
        hSlopeRisingEdge= (TH1F*) calloc(mMaxPulseOrder, sizeof(TH1F));
    if (mOptions == "R")
        hRisingToMaxEdge= (TH1F*) calloc(mMaxPulseOrder, sizeof(TH1F));
    if (mOptions == "P")
        hPosOfMax       = (TH1F*) calloc(mMaxPulseOrder, sizeof(TH1F));

    hList           = new TObjArray;

    BookPixelHistos();
    BookDistributionHistos()
}

Pixel::~Pixel()
{
    if (mVerbosityLevel > 2) cout << endl << "...delete current pixel histograms" ;
    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxOverlay" << mHistogramId;
        delete hMaxOverlay[order];
        hMaxOverlay = NULL;
        if (mVerbosityLevel > 3) cout << endl << "...deleting hEdgeOverlay" << mHistogramId;
        delete hEdgeOverlay[order];
        hEdgeOverlay = NULL;
        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxProfile" << mHistogramId;
        delete hMaxProfile[order];
        hMaxProfile = NULL;
        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxProfile2" << mHistogramId;
        delete hEdgeProfile[order];
        hEdgeProfile = NULL;
    }
    if (mVerbosityLevel > 3) cout << endl << "...deleting hList";
    delete hList;
    if (mVerbosityLevel > 2) cout << endl << "...done" << endl;
}// ~Pixel


//============================= OPERATORS ====================================

//XX&
//XX::operator=(const XX&);
//{
//    return *this;

//}// =

//============================= OPERATIONS ===================================
void
Pixel::BookPixelHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...book pixel histograms" << endl;
    TString histo_name;
    for (int order = 0; order < mMaxPulseOrder; order ++)
    {
/*
                SetHistogramAttributes(
                            "PeakMaxGaus",
                            order,
                            gMaxGausAttrib,
                            MaxAmplOfFirstPulse
                            );
                            */
        histo_name = "hMaxOverlay";
        histo_name += order;
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hMaxOverlay[order] = TH2F(
                    histo_name,
                    "Overlay of detected pulses of one pulse order for one Pixel",
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                    (-1*mPixelOverlayXaxisLeft)-0.5,
                    mPixelOverlayXaxisRight-0.5 ,
                    512,
                    -55.5,
                    200.5
                    );
        hMaxOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hMaxOverlay[order] );

//------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name = "hEdgeOverlay";
        histo_name += order;
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hEdgeOverlay[order] = TH2F(
                    histo_name,
                    "Overlay at rising edge of detected pulses of one pulse order for one Pixel ",
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                    (-1*mPixelOverlayXaxisLeft)-0.5,
                    mPixelOverlayXaxisRight-0.5 ,
                    512,
                    -55.5,
                    200.5
                    );

        hEdgeOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        hList->Add( hEdgeOverlay[order] );

    //------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name = "hMaxProfile";
        histo_name += order;
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hMaxProfile[order] = TProfile(
                    histo_name,
                    "Mean value of each slice in overlay plot (Tprofile)",
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hMaxProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hMaxProfile[order] );


    //------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
            histo_name = "hEdgeProfile";
            histo_name += order;
            if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
            hEdgeProfile[order] = TProfile(
                        histo_name,
                        "Mean value of each slice in overlay plot (Tprofile)",
                        mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                        (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                        mPixelOverlayXaxisRight-0.5 ,                    //xup
        //                512,                                            //nbinsy
                        -55.5,                                          //ylow
                        300.5,                                          //yup
                        "s");                                           //option
            hEdgeProfile[order]->SetLineColor(kRed);
            hEdgeProfile[order]->SetAxisRange(
                        mBSLMean - 5,
                        (mGainMean*(order+1)) + 10,
                        "Y");
            hEdgeProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
            hEdgeProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
            //hMaxProfile->SetBit(TH2F::kCanRebin);
    }
    if (mVerbosityLevel > 2) cout << "...done" << endl;
}
//end of BookPixelHistos
//----------------------------------------------------------------------------


void
Pixel::DrawHistograms(
        TCanvas*    pixelCanvas     = NULL,
        int*        histoFrameNr    = NULL
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing pulse histograms" ;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        pixelCanvas[pulse_order]->cd( histoFrameNr[0] );
        hMaxOverlay[pulse_order]->Draw("COLZ");
        pixelCanvas[pulse_order]->cd( histoFrameNr[2] );
        hMaxProfile[pulse_order]->Draw("COLZ");
        hMaxProfile2[pulse_order]->Draw("SAME");

        pixelCanvas[pulse_order]->cd( histoFrameNr[1] );
        hEdgeOverlay[pulse_order]->Draw("COLZ");
    }
}
// end of DrawPulseHistograms
//----------------------------------------------------------------------------


void
Pixel::BookDistributionHistos( )
{
    if (mOptions != "")
    {
        if (mVerbosityLevel > 2) cout << endl
                                      << "...book distribution histograms"
                                      << endl;

            if (mOptions != "S")
            {
                hSlopeRisingEdge = TH1F (
                            "hSlopeRisingEdge",
                            "Distribution of rising edge",
                            600,
                            -10.1,
                            10.1
                            );
                hSlopeRisingEdge->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hSlopeRisingEdge->GetYaxis()->SetTitle( "counts" );
            }

            if (mOptions != "R")
            {
                hRisingToMaxEdge = TH1F (
                            "hRisingToMaxEdge",
                            "Deviation of rising edge and maximum",
                            600,
                            -10.1,
                            10.1
                            );
                hRisingToMaxEdge->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hRisingToMaxEdge->GetYaxis()->SetTitle( "counts" );
            }

            if (mOptions != "P")
            {
                hPosOfMax = TH1F (
                            "hPosOfMax",
                            "Deviation of rising edge and maximum",
                            600,
                            -10.1,
                            10.1
                            );
                hPosOfMax->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hPosOfMax->GetYaxis()->SetTitle( "counts" );
            }

        if (mVerbosityLevel > 2) cout << "...done" << endl;
    }
}




//============================= ACESS      ===================================
//============================= INQUIRY    ===================================
/////////////////////////////// PROTECTED  ///////////////////////////////////

/////////////////////////////// PRIVATE    ///////////////////////////////////








