#ifndef ROOTFILEHANDLER_H
#define ROOTFILEHANDLER_H

void
CreateRootFile(
        const char* loc_fname,
        int         verbosityLevel
        );

TFile*
OpenRootFile(
        const char* loc_fname,
        int         verbosityLevel
        );

void
CloseRootFile(
        TFile*      tf
        );

void
SaveHistograms(
        const char* loc_fname,
        const char* subdirectory,
        TObjArray*  histList,
        int         verbosityLevel
        );

TString
CreateSubDirName(
        int         pixel
        );

TString
CreateSubDirName(
        const char* title
        );

int
CalculateHistogramId(
        int         pixelID,
        int         pulseOrder,
        int         maxPulseOrder
        );

int
CalculatePixelId(
        int         histrogramID,
        int         pulseOrder,
        int         maxPulseOrder
        );

int
CalculatePulseOrder(
        int         mHistogramId,
        int         maxPulseOrder
        );


#endif // ROOTFILEHANDLER_H
