#include "pixel.h" // class implemented
using namespace std;

/////////////////////////////// PUBLIC ///////////////////////////////////////

//============================= LIFECYCLE ====================================

//Pixel::Pixel(int pixelID)
//{
//    Chid                                = pixelID;
//    max_puslse_order                    = 1;
//    hMaxOverlay                       = NULL;
//    hEdgeOverlay                   = NULL;
//    hMaxProfile                       = NULL;
//    hEdgeProfile                      = NULL;
//    hList                               = NULL;

//}

Pixel::Pixel(
        int         pixelID,
        int         maxPulsorder,
        int         verbosityLevel,
        int         pixelOverlayXaxisLeft,
        int         pixelOverlayXaxisRight,
        int         bSLMean,
        int         gainMean,
        TString options
        )
{
    mChid                   = pixelID;
    mMaxPulseOrder          = maxPulsorder;
    mVerbosityLevel         = verbosityLevel;
    mOptions                = options;
    mPixelOverlayXaxisLeft  = pixelOverlayXaxisLeft;
    mPixelOverlayXaxisRight = pixelOverlayXaxisRight;
    mBSLMean                = bSLMean;
    mGainMean               = gainMean;

//    hMaxOverlay     = (TH2F*) calloc(mMaxPulseOrder, sizeof(TH2F*));
    hMaxOverlay = new TH2F*[mMaxPulseOrder];
//    hEdgeOverlay    = (TH2F*) calloc(mMaxPulseOrder, sizeof(TH2F*));
    hEdgeOverlay = new TH2F*[mMaxPulseOrder];
//    hMaxProfile     = (TProfile*) calloc(mMaxPulseOrder, sizeof(TProfile));
    hMaxProfile = new TProfile*[mMaxPulseOrder];
//    hEdgeProfile    = (TProfile*) calloc(mMaxPulseOrder, sizeof(TProfile));
    hEdgeProfile = new TProfile*[mMaxPulseOrder];
    if (mOptions == "S")
    {
//        hSlopeRisingEdge= (TH1F*) calloc(mMaxPulseOrder, sizeof(TH1F));
        hSlopeRisingEdge = new TH1F*[mMaxPulseOrder];
    }
    if (mOptions == "R")
    {
//        hRisingEdgeToMax= (TH1F*) calloc(mMaxPulseOrder, sizeof(TH1F));
        hRisingEdgeToMax = new TH1F*[mMaxPulseOrder];
    }
    if (mOptions == "P")
    {
//        hPosOfMax       = (TH1F*) calloc(mMaxPulseOrder, sizeof(TH1F));
        hPosOfMax = new TH1F*[mMaxPulseOrder];
    }

    hList           = new TObjArray;

    BookPixelHistos();
    BookDistributionHistos();
}

Pixel::~Pixel()
{
    if (mVerbosityLevel > 2) cout << endl << "...delete current pixel histograms" ;

    DeletePixelHistos();
    DeleteDistributionHistos();
    delete hList;
    hList = NULL;

}// ~Pixel


//============================= OPERATORS ====================================

//XX&
//XX::operator=(const XX&);
//{
//    return *this;

//}// =

//============================= OPERATIONS ===================================
void
Pixel::BookPixelHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...book pixel histograms" << endl;
    TString histo_name;

    for (int order =0; order > mMaxPulseOrder; order++)
    {
        histo_name = "hMaxOverlay";
        histo_name += order;
        hMaxOverlay[order]=new TH2F(
                histo_name,
                "Overlay of detected pulses of one pulse order for one Pixel",
                mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                (-1*mPixelOverlayXaxisLeft)-0.5,
                mPixelOverlayXaxisRight-0.5 ,
                512,
                -55.5,
                200.5
                );
/*
                SetHistogramAttributes(
                            "PeakMaxGaus",
                            order,
                            gMaxGausAttrib,
                            MaxAmplOfFirstPulse
                            );
                            */
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hMaxOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hMaxOverlay[order] );
    }

    for (int order = 0; order < mMaxPulseOrder; order ++)
    {

//------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name = "hEdgeOverlay";
        histo_name += order;
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hEdgeOverlay[order] = new TH2F(
                    histo_name,
                    "Overlay at rising edge of detected pulses of one pulse order for one Pixel ",
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                    (-1*mPixelOverlayXaxisLeft)-0.5,
                    mPixelOverlayXaxisRight-0.5 ,
                    512,
                    -55.5,
                    200.5
                    );

        hEdgeOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        hList->Add( hEdgeOverlay[order] );

    //------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name = "hMaxProfile";
        histo_name += order;
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hMaxProfile[order] = new TProfile(
                    histo_name,
                    "Mean value of each slice in overlay plot (Tprofile)",
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hMaxProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hMaxProfile[order] );


    //------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name = "hEdgeProfile";
        histo_name += order;
        if (mVerbosityLevel > 3) cout << "...booking " << histo_name << endl;
        hEdgeProfile[order] = new TProfile(
                    histo_name,
                    "Mean value of each slice in overlay plot (Tprofile)",
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hEdgeProfile[order]->SetLineColor(kRed);
        hEdgeProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hEdgeProfile[order] );

    }
    if (mVerbosityLevel > 2) cout << "...done" << endl;
}
//end of BookPixelHistos
//----------------------------------------------------------------------------


void
Pixel::DrawHistograms(
        TCanvas*    pixelCanvas,
        int*        histoFrameNr
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing pulse histograms" ;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        pixelCanvas[pulse_order].cd( histoFrameNr[0] );
        hMaxOverlay[pulse_order]->Draw("COLZ");
        pixelCanvas[pulse_order].cd( histoFrameNr[2] );
        hMaxProfile[pulse_order]->Draw("COLZ");
        hEdgeProfile[pulse_order]->Draw("SAME");

        pixelCanvas[pulse_order].cd( histoFrameNr[1] );
        hEdgeOverlay[pulse_order]->Draw("COLZ");
    }
}
// end of DrawPulseHistograms
//----------------------------------------------------------------------------


void
Pixel::BookDistributionHistos( )
{
    if (mOptions != "")
    {
        TString histo_name;
        for (int order =0; order > mMaxPulseOrder; order++)
        {
            if (mVerbosityLevel > 2) cout << endl
                                          << "...book distribution histograms"
                                          << endl;

            if (mOptions.Contains("S"))
            {
                histo_name = "hSlopeRisingEdge";
                histo_name += order;
                hSlopeRisingEdge[order] = new TH1F (
                            histo_name,
                            "Distribution of rising edge",
                            600,
                            -10.1,
                            10.1
                            );
                hSlopeRisingEdge[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hSlopeRisingEdge[order]->GetYaxis()->SetTitle( "counts" );
                hList->Add( hSlopeRisingEdge[order] );
            }

            if (mOptions.Contains("R"))
            {
                histo_name = "hRisingEdgeToMax";
                histo_name += order;
                hRisingEdgeToMax[order] = new TH1F (
                            histo_name,
                            "Deviation of rising edge and maximum",
                            600,
                            -10.1,
                            10.1
                            );
                hRisingEdgeToMax[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hRisingEdgeToMax[order]->GetYaxis()->SetTitle( "counts" );
                hList->Add( hRisingEdgeToMax[order] );
            }

            if (mOptions.Contains("P"))
            {
                histo_name = "hPosOfMax";
                histo_name += order;
                hPosOfMax[order] = new TH1F (
                            histo_name,
                            "Deviation of rising edge and maximum",
                            600,
                            -10.1,
                            10.1
                            );
                hPosOfMax[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hPosOfMax[order]->GetYaxis()->SetTitle( "counts" );
                hList->Add( hPosOfMax[order] );
            }

            if (mVerbosityLevel > 2) cout << "...done" << endl;
        }
    }
}

void
Pixel::DrawDistributionHistograms(
        TCanvas*    pixelCanvas,
        int*        histoFrameNr
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing distribution histograms" ;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        pixelCanvas[pulse_order].cd( histoFrameNr[0] );
        hSlopeRisingEdge[pulse_order]->Draw();
        pixelCanvas[pulse_order].cd( histoFrameNr[1] );
        hRisingEdgeToMax[pulse_order]->Draw();

        pixelCanvas[pulse_order].cd( histoFrameNr[2] );
        hPosOfMax[pulse_order]->Draw();
    }
}
// end of DrawDistributionHistograms
//----------------------------------------------------------------------------

void
Pixel::SavePixelHistograms(
        const char* outRootFileName,
        bool        saveResults
        )
{
    if (!saveResults) return;
    SaveHistograms(
            outRootFileName,
            CreateSubDirName( mChid ),
            hList,
            saveResults,
            mVerbosityLevel
            );
}
// end of SavePixelHistograms
//----------------------------------------------------------------------------

void
Pixel::DeletePixelHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...delete current overlay histograms" ;

    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxOverlay";
        delete hMaxOverlay[order];

        if (mVerbosityLevel > 3) cout << endl << "...deleting hEdgeOverlay";
        delete hEdgeOverlay[order];

        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxProfile";
        delete hMaxProfile[order];

        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxProfile2";
        delete hEdgeProfile[order];
    }
    if (mVerbosityLevel > 3) cout << endl << "...deleting histogram Arrays";
    delete[] hMaxOverlay;
    hMaxOverlay = NULL;

    delete[] hEdgeOverlay;
    hEdgeOverlay = NULL;

    delete[] hMaxProfile;
    hMaxProfile = NULL;

    delete[] hEdgeProfile;
    hEdgeProfile = NULL;
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

void
Pixel::DeleteDistributionHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...delete current distribution histograms" ;

    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxOverlay";
        delete hSlopeRisingEdge[order];

        if (mVerbosityLevel > 3) cout << endl << "...deleting hEdgeOverlay";
        delete hRisingEdgeToMax[order];

        if (mVerbosityLevel > 3) cout << endl << "...deleting hMaxProfile";
        delete hPosOfMax[order];

    }
    if (mVerbosityLevel > 3) cout << endl << "...deleting histogram Arrays";


    delete[] hSlopeRisingEdge;
    hSlopeRisingEdge = NULL;

    delete[] hRisingEdgeToMax;
    hRisingEdgeToMax = NULL;

    delete[] hPosOfMax;
    hPosOfMax = NULL;
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

//============================= ACESS      ===================================
//============================= INQUIRY    ===================================
/////////////////////////////// PROTECTED  ///////////////////////////////////

/////////////////////////////// PRIVATE    ///////////////////////////////////








