/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#include "MGenPrimaryParticle.h"

#include <TMath.h>
#include <TF1.h>

#include "MParList.h"
#include "MParticle.h"

ClassImp(MGenPrimaryParticle);

Double_t PowerLaw(Double_t *x, Double_t *k)
{
    return 1/x[0];
}

// --------------------------------------------------------------------------
MGenPrimaryParticle::MGenPrimaryParticle(const char *name, const char *title)
    : fPi2(TMath::Pi()*2)
{
    fName  = name  ? name  : "MGenPrimaryParticle";
    fTitle = title ? title : "";

    fSrc = new TF1("Power-Law", PowerLaw, 10,   1e8, 0); // 10GeV-100PeV
}

MGenPrimaryParticle::~MGenPrimaryParticle()
{
    delete fSrc;
}

// --------------------------------------------------------------------------
Bool_t MGenPrimaryParticle::PreProcess(MParList *pList)
{
    fList = (MParList*)pList->FindCreateObj("MParticleList");
    if (!fList)
        return kFALSE;

    return kTRUE;
} 

// --------------------------------------------------------------------------
Bool_t MGenPrimaryParticle::Process()
{
    MParticle *p = new MParticle(MParticle::kEGamma);
    p->SetEnergy(fSrc->GetRandom());
    return kTRUE;
} 

Bool_t MGenPrimaryParticle::PostProcess()
{
    return kTRUE;
}
