#ifndef MARS_MParticle
#define MARS_MParticle

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MParticle : public MParContainer
{
public:
    typedef enum { kEGamma, kEElectron, kEPositron } ParticleType_t;

private:
    const ParticleType_t fPType;

protected:
    Double_t fEnergy; // [GeV] Energy
    Double_t fBeta;   // [1]   beta
    Double_t fAngle;  // [rad] Angle
    Double_t fZ;      // [1]   Red shift

public:
    MParticle(ParticleType_t t, const char *name=NULL, const char *title=NULL);
     //    ~MParticle();

    //    void Fill(const MParContainer *inp);

    //    void Draw(Option_t *opt=NULL);

    void SetEnergy(Double_t e) { fEnergy = e; }
    void SetAngle(Double_t a)  { fAngle = a; }
    void SetBeta(Double_t b)   { fBeta = b; }
    void SetZ(Double_t z)      { fZ = z; }

    Double_t GetEnergy() const { return fEnergy; }
    Double_t GetAngle() const  { return fAngle; }
    Double_t GetZ() const      { return fZ; }

    ClassDef(MParticle, 1) // Container which holds hostograms for the Hillas parameters
};

#endif

