#ifndef MARS_MPhoton
#define MARS_MPhoton

#ifndef MARS_MParticle
#include "MParticle.h"
#endif

class MPhoton : public MParticle
{
public:
    MPhoton(Double_t e=0, Double_t z=0) : MParticle(MParticle::kEGamma)
    {
        fEnergy = e;
        fZ      = z;
    }

    static Double_t Planck(Double_t *x, Double_t *k=NULL);
    static Double_t Sigma_gg(Double_t *x, Double_t *k=NULL);
    static Double_t Int1(Double_t *x, Double_t *k=NULL);
    static Double_t Int2(Double_t *x, Double_t *k);
    static Double_t InteractionLength(Double_t *x, Double_t *k=NULL);
    static Double_t GetInteractionLength(Double_t energy, Double_t z=0);

    Double_t GetInteractionLength() const;

    ClassDef(MPhoton, 1)
};

#endif
