#ifndef MARS_MParticle
#define MARS_MParticle

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MParticle : public MParContainer
{
public:
    typedef enum { kEGamma, kEElectron, kEPositron } ParticleType_t;

private:
    const ParticleType_t fPType;

protected:
    Double_t fEnergy; // [GeV] Energy
    Double_t fBeta;   // [1]   beta

    Double_t fZ;      // [1]   Red shift
    Double_t fR;      // [kpc] Radius from line of view
    Double_t fPhi;    // [rad] Phi@z from line of view

    Double_t fTheta;  // [rad] Direction of momentum, angle || line of view
    Double_t fPsi;    // [rad] Direction of momentum, az. angle

public:
    MParticle(ParticleType_t t, const char *name=NULL, const char *title=NULL);
     //    ~MParticle();

    void operator=(MParticle &p)
    {
        fZ = p.fZ;
        fR = p.fR;
        fPhi = p.fPhi;
        fTheta = p.fTheta;
        fPsi = p.fPsi;
    }

    //    void Fill(const MParContainer *inp);

    //    void Draw(Option_t *opt=NULL);
    virtual Double_t GetInteractionLength() const = 0;

    void SetEnergy(Double_t e) { fEnergy = e; }
    void SetBeta(Double_t b)   { fBeta = b; }

    void SetZ(Double_t z)      { fZ = z; }
    /*
     void SetPhi(Double_t p)    { fPhi = p; }
     void SetR(Double_t r)      { fR = r; }
     void SetTheta(Double_t t)  { fTheta = t; }
     void SetPsi(Double_t p)    { fPsi = p; }
     */

    void SetNewDirection(Double_t theta, Double_t phi);
    Bool_t SetNewPosition(Double_t dr);
    Bool_t SetNewPosition();

    Double_t GetEnergy() const { return fEnergy; }

    Double_t GetZ() const      { return fZ; }
    Double_t GetPhi() const    { return fPhi; }
    Double_t GetR() const      { return fR; }

    Double_t GetTheta() const  { return fTheta; }
    Double_t GetPsi() const    { return fPsi; }

    ClassDef(MParticle, 1) // Container which holds hostograms for the Hillas parameters
};

#endif

