#include <iostream>
#include "TObjArray.h"

#include "rootfilehandler.h"

using namespace std;

void
CreateRootFile(
        const char*     loc_fname,
        int             verbosityLevel
        )
{
    TFile* tf = new TFile(loc_fname,"UPDATE");
    if (tf->IsZombie())
    {
        cout << "Error opening file" << endl;
        exit(-1);
    }
    else {
        if (verbosityLevel > 1) cout << "creating root-file successfull" << endl;
        tf->Close();
    }
}
//end of CreateRootFile
//----------------------------------------------------------------------------


TFile*
OpenRootFile(
        const char * loc_fname,
        int verbosityLevel
        )
{
    TFile* tf = new TFile(loc_fname,"UPDATE");
    if (tf->IsZombie())
    {
        cout << "Error opening file" << endl;
        exit(-1);
    }
    else {
        if (verbosityLevel > 1) cout << "...opening root-file:"
                                     << loc_fname
                                     << " successfull" << endl;
    }
    return tf;
}
//end of OpenRootFile
//----------------------------------------------------------------------------


void
CloseRootFile(
        TFile* tf
        )
{
    if (tf->IsZombie())
    {
    cout << "Error closing file" << endl;
    exit(-1);
    } else {
    tf->Close();
    }
}
//end of CloseRootFile
//----------------------------------------------------------------------------


void
SaveHistograms(
        const char*     loc_fname,
        TString         subdirectory,
        TObjArray*      histList,
        bool            saveResults,
        int             verbosityLevel
        )
{
    if (!saveResults) return;
    if (verbosityLevel > 2) cout << endl
                                 << "...saving pixel histograms to subdirectory: "
                                 << subdirectory << endl ;

    TFile* tf = OpenRootFile(loc_fname, verbosityLevel);
    if ( !( subdirectory.CompareTo("root") ) ) //if subdirectory = root
    {
        tf->cd();
        tf->mkdir(subdirectory,subdirectory);
        tf->cd(subdirectory);
    }
    else
    {
        tf->cd();
    }
    histList->Write(); // write the major histograms into the top level directory
    if (verbosityLevel > 3) tf->ls();
    CloseRootFile( tf ); // close the file
    if (verbosityLevel > 2) cout << "...done" << endl;
}
// end of SaveHistograms
//----------------------------------------------------------------------------


TString
CreateSubDirName(
        int pixel
        )
{
    TString path = "Pixel_";
    path += pixel;
//    cout << "path " << path << endl ;
    return path;
}
// end of CreateSubDirName
//----------------------------------------------------------------------------


TString
CreateSubDirName(
        const char* title
        )
{
    TString path = title;
    path += "_Pixel";
//    cout << "path " << path << endl ;
    return path;
}
// end of CreateSubDirName
//----------------------------------------------------------------------------

