#ifndef __DRS_CALIBRATION__H
#define __DRS_CALIBRATION__H

#include <vector>
#include <stdint.h>

float getValue( int slice, int pixel,
    std::vector<float> &drs_basemean,
    std::vector<float> &drs_gainmean,
    std::vector<float> &drs_triggeroffsetmean,
    unsigned int RegionOfInterest,
    std::vector<int16_t> AllPixelDataVector,
    std::vector<int16_t> StartCellVector
);

size_t applyDrsCalibration( 
    std::vector<float> &destination,
    int pixel, 
    int LeaveOutLeft,
    int LeaveOutRight,
    std::vector<float> &drs_basemean,
    std::vector<float> &drs_gainmean,
    std::vector<float> &drs_triggeroffsetmean,
    unsigned int RegionOfInterest,
    std::vector<int16_t> AllPixelDataVector,
    std::vector<int16_t> StartCellVector,
    int verbosityLevel  = 1
);

#endif
