#ifndef __OPENFITS__H
#define __OPENFITS__H

#include "fits.h"

#include <cstdio>
#include "stdint.h"
#include <vector>

size_t openDataFits(
	const char *datafilename,		// path to fits file containing FACT raw data
	std::fits * * datafile,				// ptr to pointer, where to return the fits object
	std::vector<int16_t> &Data,			// vector, which will be filled with raw data
	std::vector<int16_t> &StartCells,	// vector, which will be filled with DRS start positions
	unsigned int &EventID,			// index of the current event
	unsigned int &RegionOfInterest,		// Width of the Region, read out of the DRS
	unsigned int &NumberOfPixels,			// Total number of pixel, read out of the camera
	size_t &PXLxROI,				// Size of column "Data" = #Pixel x ROI
			// this can be used, to x-check RegionOfInterest and NumberOfPixels
	int VerbosityLevel = 1				//
);

size_t openCalibFits(
  const char *FileName,     // path to fits file
  std::vector<float> &Offset,
  std::vector<float> &Gain,
  std::vector<float> &TriggerOffset,
  size_t &TriggerOffsetROI,
  int VerbosityLevel =0
);


#endif //__OPENFITS__H
