
#include <deque>
#include "factfir.h"

using namespace std;

// source vector is
void factfir(double b, vector<double> &a, int k, vector<float> &source, vector<float> &dest){
	//dest.clear();

	for (int slice =0; slice < (int)source.size(); slice++) {
		float currentval = 0;

		for (int i=0; i < k ; i++){
			currentval += a[i] * source[ (slice - i + source.size()) % source.size() ];
		}
		dest[slice] = currentval / b;
	}
}

void sliding_avg(vector<float> &source, vector<float> &dest, unsigned int HalfWidth){
	// make local copy of source, in case source and dest are the same

	deque<float> local;
	local.insert(local.end(), source.begin(), source.end());
	// edge treatment.
	local.insert(local.begin(), HalfWidth, source[0]);
	local.insert(local.end(), HalfWidth, source[source.size()-1]);

	deque<float>::iterator it;

	dest.clear();

	float x;
	for (it=local.begin()+HalfWidth; it<local.end()-HalfWidth; ++it) {

		x=*it;
		float FullWidth = 2*HalfWidth+1;

		for ( unsigned int i=0; i < HalfWidth ; i++){
			x += *(it+i); // add the right neighbors
			x += *(it-i); // and don't forget the left neighbors on the left
		}

		dest.push_back(x/FullWidth);
	}
}

