/********************** FPulseOverlay ***********************
* read FACT raw data
* remove spikes
* calculate baseline
* find peaks (CFD and normal discriminator)
+ search for Peaks in data
+ put peaks into different histos depending on Amplitude
+ draw histos for single, double, tripple, ....Photonpulses
+ draw Parameterdevelopment
  so it can be used for detection of other peaks
*************************************************************/
//----------------------------------------------------------------------------
// root libraries
//----------------------------------------------------------------------------

#include <TROOT.h>
#include <TCanvas.h>
#include <TProfile.h>
#include <TTimer.h>
#include <TH1F.h>
#include <TH2F.h>
#include <Getline.h>
#include <TLine.h>
#include <TBox.h>
#include <TMath.h>
#include <TFile.h>
#include <TStyle.h>
#include <TString.h>
#include <TObjArray.h>

#include <stdio.h>
#include <stdint.h>
#include <cstdio>
#include <iostream>
#include <fstream>
using namespace std;

#define NPIX  1440
#define NCELL 1024
#define FAD_MAX_SAMPLES 1024
#define HAVE_ZLIB

//----------------------------------------------------------------------------
// rootmacros
//----------------------------------------------------------------------------

//#include "../fits.h"

#include "../openFits.h"
//#include "../openFits.c"

#include "../discriminator.h"
//#include "../discriminator.C"
#include "../zerosearch.h"
//#include "../zerosearch.C"
# include "../factfir.h"
//#include "../factfir.C"

//#include "../DrsCalibration.C"
#include "../DrsCalibration.h"

#include "../SpikeRemoval.h"
//#include "../SpikeRemoval.C"

#include "rootfilehandler.h"
//#include "rootfilehandler.C"

#include "pixel.h"
//#include "pixel.C"


//----------------------------------------------------------------------------
// Decleration of global variables
//----------------------------------------------------------------------------

bool breakout=false;

vector<int16_t> AllPixelDataVector;
vector<int16_t> StartCellVector;
unsigned int CurrentEventID;
size_t PXLxROI;
UInt_t gRegionOfInterest;
UInt_t NumberOfPixels;
TString histotitle;

size_t TriggerOffsetROI, RC;
size_t drs_n;
vector<float> drs_basemean;
vector<float> drs_gainmean;
vector<float> drs_triggeroffsetmean;

vector<float> Ameas(FAD_MAX_SAMPLES);   // copy of the data (measured amplitude
vector<float> Vcorr(FAD_MAX_SAMPLES);   // corrected Values
vector<float> Vslide(FAD_MAX_SAMPLES);  // sliding average result
vector<float> Vcfd(FAD_MAX_SAMPLES);    // CDF result
vector<float> Vcfd2(FAD_MAX_SAMPLES);   // CDF result + 2nd sliding average

int gNEvents=0;
float gGainMean = 9;
float gBSLMean = 0;

//typedef struct{
//  double maxAmpl;
//  int countOfMax;
//  } OverlayMaximum;

//typedef struct{
//  TString name;
//  TString title;
//  TString xTitle;
//  TString yTitle;
//  float yMax;
//  float yMin;
//} histAttrib_t;

//histAttrib_t* gHistoAttrib[maxPulseOrder];
//histAttrib_t* gProfileAttrib[maxPulseOrder];


// histograms
const int Number_Of_Debug_Histo_Types = 7;

const unsigned int
        Ameas_ 	= 0,
        N1mean_ = 1,
        Vcorr_  = 2,
        Vtest_  = 3,
        Vslide_ = 4,
        Vcfd_   = 5,
        Vcfd2_  = 6;

//const char* gHistoTypes[8] = {
//    "hMaxOverlay",
//    "hPixelMax",
//    "hEdgeOverlay",
//    "hMaxProfile",
//    "hAllPixelOverlay",
//    "hAllPixelMax",
//    "hAllPixelMaxGaus",
//    "hAllPixelProfile"
//};

//----------------------------------------------------------------------------
// Initialisation of histograms
//----------------------------------------------------------------------------

    // Temporary Objects
    TH1F*       debugHistos     = NULL;
    //TH2F*       hOverlayTemp = NULL;
    //TH1D*       hProjPeak = NULL;
    TH1F*       hTesthisto      = NULL;
    TH2F*       hTesthisto2     = NULL;

    //Histogram Parameters
    Int_t       gPixelOverlayXaxisLeft  = 0;
    Int_t       gPixelOverlayXaxisRight = 0;

    //Root-File Objects
//    TObjArray*  hList[sampleSetSize] = {NULL};
    TObjArray*  hRootList           = NULL;

    TCanvas**   cgpPixelPulses      = NULL;
    TCanvas**   cgpDistributions    = NULL;
    TCanvas*    cFiltered           = NULL;
    TCanvas*    cgpTestHistos       = NULL;

//----------------------------------------------------------------------------
// Functions
//----------------------------------------------------------------------------

void BookDebugHistos(int );
void BookTestHistos( int );

//void DeletePixelHistos(int );
//void SaveHistograms( const char*, const char*, TObjArray*, int );

void FillHistograms(Pixel*, vector<Region>*, int, int, TString, int, int);
void DrawTestHistograms( int);
void ProduceDebugHistos( vector<Region> *pZXings);

void UpdateCanvases( int, int);
void DeletePixelCanvases( int, int );

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// MAIN - Funtion
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
int FPulseOverlay(
        const char*     datafilename        = "/fact/raw/2011/11/09/20111109_006.fits.gz",
        const char*     drsfilename         = "/fact/raw/2011/11/09/20111109_003.drs.fits.gz",
        const char*     OutRootFileName     = "test.root",
        bool            ProduceGraphic      = false,
        bool            spikeDebug          = false,
        bool            debugPixel          = false,
        bool            testmode            = false,
        bool            saveResults         = false,
        int             verbosityLevel      = 1,        // different verbosity levels can be implemented here
        int             firstevent          = 1,        // Hast to be between 1 and infinity NOT 0!!!!
        int             nevents             = 100,
        int             firstpixel          = 0,
        int             npixel              = -1,
        int             sampleSetSize       = 40,
        int             maxPulseOrder       = 3,
        int             AmplWindowWidth     = 14,       //Width of Window for selection of pulses to histograms
        TString         histoOptions        = "S",
        float           GainMean            = 8,
        float           BSLMean             = -1,        //4 Histogramms will be drawn, decide how far pulsehights differ from eachother
        int             avg1                = 8,
        int             avg2                = 8,
        int             OverlayWindowLeft   = 70,
        int             OverlayWindowRight  = 230,
        int             refresh_rate        = 500      //refresh rate for canvases
        )
{

//----------------------------------------------------------------------------
//	Save-Root-File Settings
//----------------------------------------------------------------------------
    if (saveResults)
    {
    CreateRootFile( OutRootFileName, verbosityLevel );
    }

//----------------------------------------------------------------------------
//	root global Settings
//----------------------------------------------------------------------------

    gGainMean = GainMean;
    gBSLMean = BSLMean;
    gPixelOverlayXaxisLeft = OverlayWindowLeft;
    gPixelOverlayXaxisRight = OverlayWindowRight;

    gStyle->SetPalette(1,0);
    gROOT->SetStyle("Plain");
//    gPad->SetGrid();

//----------------------------------------------------------------------------
//	root Canvas Settings
//----------------------------------------------------------------------------
    //Canvas Pad numbering
    int pulsesCanvasFrameNrs[4] = {
        1,  // Top left
        2,  // Top right
        3,  // bottom left
        4   // bootom right
    };

    //Canvas Pad numbering
    int distributionCanvasFrameNrs[4] = {
        1,  // Top left
        2,  // Top right
        3,  // bottom left
        4   // bootom right
    };

    if (ProduceGraphic)
    {

        //Canvases
        cgpPixelPulses      = new TCanvas*[maxPulseOrder];
        cgpDistributions    = new TCanvas*[maxPulseOrder];

        //TCanvas*    gpcDevelopment = NULL;
        TString cName   = "";
        TString cTitle  = "";

        //naming of pulse canvases
        for (
             int pulse_order = maxPulseOrder - 1;
             pulse_order >= 0 ;
             pulse_order--
              )
        {
            cName   ="cgpDistributions";
            cName   += pulse_order;
            cTitle   ="Pulses of Order: ";
            cTitle   += pulse_order;
            cgpDistributions[pulse_order] = new TCanvas(cName,cTitle, 0,pulse_order*20,800,800);
            cgpDistributions[pulse_order]->Divide(2, 2);
            cName   ="cgpPixelPulses";
            cName   += pulse_order;
            cTitle   ="Pulses of Order: ";
            cTitle   += pulse_order;
            cgpPixelPulses[pulse_order] = new TCanvas(cName,cTitle, 0,pulse_order*20,800,800);
            cgpPixelPulses[pulse_order]->Divide(2, 2);
        }


        // Create (pointer to) Canvases, which are used in every run,
        // also in 'non-debug' runs
                // Canvases only need if spike Debug, but I want to deklare
                // the pointers anyway ...
        if (spikeDebug)
        {
          cFiltered = new TCanvas("cFiltered","filtered DRS Waveforms", 1,310,400,300);
          cFiltered->Divide(1, 3);
        }

        //additional Test histograms
        cgpTestHistos = new TCanvas( "cgpTestHistos", "Test Histograms", 801, 0, 800, 800 );
        cgpTestHistos->Divide(2,0);
    }

//-----------------------------------------------------------------------------
// Filter-Settings
//-----------------------------------------------------------------------------
// CFD filter settings
    int k_cfd = 10;
    vector<double> a_cfd(k_cfd, 0);
    double b_cfd = 1.;
    a_cfd[0]=-0.75;
    a_cfd[k_cfd-1]=1.;

//-----------------------------------------------------------------------------
// prepare datafile
//-----------------------------------------------------------------------------

// Open the data file

    fits * datafile;
    // Opens the raw data file and 'binds' the variables given as
    // Parameters to the data file. So they are filled with
    // raw data as soon as datafile->GetRow(int) is called.
    gNEvents = openDataFits(
                    datafilename,
                    &datafile,
                    AllPixelDataVector,
                    StartCellVector,
                    CurrentEventID,
                    gRegionOfInterest,
                    NumberOfPixels,
                    PXLxROI,
                    verbosityLevel
                );

    if (gNEvents == 0)
    {
        cout << "return code of OpenDataFile:" << datafilename<< endl;
        cout << "is zero -> aborting." << endl;
        return 1;
    }

    if (verbosityLevel > 0)
    {
        cout << endl <<"number of events in file: "<< gNEvents << "\t";
    }

    if ( nevents == -1 || nevents > gNEvents ) nevents = gNEvents; // -1 means all!

    if (verbosityLevel > 0)
    {
        cout <<"of, which "<< nevents << " will be processed"<< endl;
        cout <<"Total # of Pixel: "<< NumberOfPixels << "\t";
    }

    if ( npixel == -1 || npixel > (int)NumberOfPixels  ) npixel = (int)NumberOfPixels; // -1 means all!

    if (verbosityLevel > 0)
    {
        cout <<"of, which "<< npixel << " will be processed"<< endl;
    }

    //Get the DRS calibration
    RC = openCalibFits(
                drsfilename,
                drs_basemean,
                drs_gainmean,
                drs_triggeroffsetmean,
                TriggerOffsetROI
                );

    if (RC == 0)
    {
     cout << "return code of openCalibFits:" << drsfilename << endl;
     cout << "is zero -> aborting." << endl;
     return 1;
    }

//-----------------------------------------------------------------------------
// Book the histograms
//-----------------------------------------------------------------------------

    if (spikeDebug)
        BookDebugHistos(verbosityLevel );

    if (testmode)
        BookTestHistos( verbosityLevel );


//-----------------------------------------------------------------------------
// Main Cycle
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Initialize Pixel
//----------------------------------------------------------------------------
    Pixel** pixel = new Pixel*[NPIX];

    for (int i = 0 ; i < NPIX; i++)
    {
        pixel[i] = NULL;
    }
//-------------------------------------
// Loop over Pixel Sets
//-------------------------------------
    for ( int firstPixelOfSample = firstpixel;
          firstPixelOfSample < firstpixel + npixel;
          firstPixelOfSample += sampleSetSize )
    {

        if (verbosityLevel == 0)
        {
            cout << "------------------------------------------------" << endl
                 << "...processing Sample from Pixel "
                 << firstPixelOfSample
                 << " to Pixel "
                 << firstPixelOfSample+sampleSetSize-1 << endl;
        }

//--------------------------------------------------------------------
// Loop over every Event of Pixel Set
//--------------------------------------------------------------------
        for ( int ev = firstevent ; ev < firstevent + nevents; ev++)
        {
            // Get an Event --> consists of 1440 Pixel ...erm....data
            cout << endl << "processing event " << ev << endl;
            datafile->GetRow( ev - 1 );

            if (verbosityLevel == 1)
            {
             cout << "-------------------------------------" << endl
                  << "...processing Sample from Pixel "
                  << firstPixelOfSample
                  << " to Pixel "
                  << firstPixelOfSample+sampleSetSize-1
                  << "... Event: " << CurrentEventID
                  << "/" << nevents << endl;
            }

//--------------------------------------------------------------------
// Loops over every Pixel of a Set of Pixels
//--------------------------------------------------------------------
            for ( int pixelID = firstPixelOfSample;
                    pixelID < firstPixelOfSample + sampleSetSize
                    && pixelID < firstpixel + npixel;
                    pixelID++ )
            {
                if (verbosityLevel > 1)
                {
                 cout << "-------------------------------------" << endl
                      << "...processing Sample from Pixel "
                      << firstPixelOfSample
                      << " to Pixel "
                      << firstPixelOfSample+sampleSetSize-1
                      << "... Event: " << CurrentEventID
                      << "/" << nevents << endl
                      << " Pixel: " << pixelID
                      << "/" << firstpixel + npixel -1 << endl;
                }

//-------------------------------------
// Create individual Pixel
//-------------------------------------
                if (ev == firstevent)
                {
                    pixel[pixelID] = new Pixel(
                                pixelID,
                                maxPulseOrder,
                                verbosityLevel,
                                gPixelOverlayXaxisLeft,
                                gPixelOverlayXaxisRight,
                                gBSLMean,
                                gGainMean,
                                histoOptions
                                );
                }

//-------------------------------------
// Apply Calibration
//-------------------------------------
                if (verbosityLevel > 2) cout << "...applying DrsCalibration";
                applyDrsCalibration(
                            Ameas,
                            pixelID,
                            12,
                            12,
                            drs_basemean,
                            drs_gainmean,
                            drs_triggeroffsetmean,
                            gRegionOfInterest,
                            AllPixelDataVector,
                            StartCellVector
                            );
                if (verbosityLevel > 2) cout << "...done " << endl;

//-------------------------------------
// Apply Filters
//-------------------------------------
                // finds spikes in the raw data, and interpolates the value
                // spikes are: 1 or 2 slice wide, positive non physical artifacts
                if (verbosityLevel > 2) cout << "...removeing Spikes";
                removeSpikes (Ameas, Vcorr);
                if (verbosityLevel > 2) cout << "...done " << endl;

                // filter Vcorr with sliding average using FIR filter function
                if (verbosityLevel > 2) cout << "...applying sliding average filter";
                sliding_avg(Vcorr, Vslide, avg1);
                if (verbosityLevel > 2) cout << "...done " << endl;

                // filter Vslide with CFD using FIR filter function
                if (verbosityLevel > 2) cout << "...apllying factfir filter";
                factfir(b_cfd , a_cfd, k_cfd, Vslide, Vcfd);
                if (verbosityLevel > 2) cout << "...done " << endl;

                // filter Vcfd with sliding average using FIR filter function
                if (verbosityLevel > 2) cout << "...applying 2nd sliding average filter";
                sliding_avg(Vcfd, Vcfd2, avg2);
                if (verbosityLevel > 2) cout << "...done " << endl;

//-------------------------------------
// Search vor Zero crossings
//-------------------------------------
                if (verbosityLevel > 2) cout << endl << "...searching zero crossings" ;
                // peaks in Ameas[] are found by searching for zero crossings
                // in Vcfd2
                // first Argument 1 means ... *rising* edge
                // second Argument 1 means ... search with stepsize 1 ... 10 is okay as well
                vector<Region>* pZXings = zerosearch( Vcfd2 , 1 , 8);
                // pZXings means "zero cross ings"
                EnlargeRegion(*pZXings, 10, 10);
                findAbsMaxInRegions(*pZXings, Vslide);
                removeMaximaBelow( *pZXings, 3.0);
                removeRegionWithMaxOnEdge( *pZXings, 2);
                removeRegionOnFallingEdge( *pZXings, 100);
                findTimeOfHalfMaxLeft(*pZXings, Vcorr, gBSLMean, 5, 10, verbosityLevel );
                if (verbosityLevel > 2) cout << "...done" << endl;

//-----------------------------------------------------------------------------
// Fill Overlay Histos
//-----------------------------------------------------------------------------
                if (verbosityLevel > 2)
                {
                    cout << endl << "Filling Histograms of Pixel# [Set] " << pixelID
                         << " Pixel# [Got] " << pixel[pixelID]->mChid;
                }
                FillHistograms(
                            pixel[pixelID],
                            pZXings,
                            AmplWindowWidth,
                            ev,
                            histoOptions,
                            maxPulseOrder,
                            verbosityLevel
                            );
//-----------------------------------------------------------------------------
// Spike Debug
//-----------------------------------------------------------------------------
                if ( spikeDebug )
                {
                    ProduceDebugHistos( pZXings );
                }// end of if(spikeDebug)

                delete pZXings;
                if (breakout)   break;
//-------------------------------------
// Draw 1. Set of Pixel Histograms
//-------------------------------------
                if ((ev % refresh_rate) == 0)
                {
                    if (ProduceGraphic)
                    {
                        if (debugPixel)
                        {
                            for ( int order = 0;
                                order < maxPulseOrder;
                                order++
                                )
                            {
                                pixel[pixelID]->DrawHistograms(
                                            cgpPixelPulses[order],
                                            pulsesCanvasFrameNrs
                                            );
                            }
                            if (testmode)
                            {
                                DrawTestHistograms(
                                            verbosityLevel
                                            );
                            }

                            UpdateCanvases(
                                        verbosityLevel,
                                        maxPulseOrder
                                        );
                        }
                    }
                }

                if (breakout) break;

                if (verbosityLevel > 1)
                {
                    cout << endl << "...End of Pixel"
                         << endl << "-------------------------------------"<< endl;
                }
            }//End of Loop over Sample
//-------------------------------------
// end of Loops over Sample
//-------------------------------------

        }//End of Loop over Events
//-------------------------------------
// end of Loops over Events
//-------------------------------------



//-------------------------------------
// Draw Pixel Histogramms of Overlay Spectra
//-------------------------------------

        for ( int pixelID = firstPixelOfSample;
              pixelID < firstPixelOfSample + sampleSetSize
              && pixelID < firstpixel + npixel;
              pixelID++ )
        {
            //here is what happends at the end of each loop over all Events
//            pixel[pixelID]->DrawHistograms(
//                        cgpPixelPulses,
//                        pulsesCanvasFrameNrs
//                        );

//            SaveHistograms(     //save histograms of generell results into output root file
//                        OutRootFileName,
//                        CreateSubDirName(pixel[pixelID]->mChid),
//                        pixel[pixelID]->hList,
//                        saveResults,
//                        verbosityLevel
//                        );

            if (ProduceGraphic)
            {
            UpdateCanvases(
                           verbosityLevel,
                           maxPulseOrder
                           );
            }

            //Save Histograms of Pixels into Output rootfile
            if (verbosityLevel > 2)
            {
                cout << endl << "Saving Pixel# [Set] " << pixelID
                 << " Pixel# [Got] " << pixel[pixelID]->mChid;
            }
            pixel[pixelID]->SavePixelHistograms( OutRootFileName, saveResults );


            if (debugPixel)
            {
                //Process gui events asynchronously during input
                cout << endl;
                TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
                timer.TurnOn();
                TString input = Getline("Type 'q' to exit, <return> to go on: ");
                timer.TurnOff();
                if (input=="q\n") {
                       break;
                }
            }

            if (verbosityLevel > 2)
            {
                cout << endl << "Deleting Pixel# [Set] " << pixelID
                     << " Pixel# [Got] " << pixel[pixelID]->mChid;
            }
            delete pixel[pixelID];

            if (verbosityLevel > 2)
            {
               cout << endl << "...End of Pixel-Set"
                    << endl << "------------------------------------------------"
                    << endl;
            }
        }
    }
    // End of Loop over all Pixels

//-------------------------------------
// Draw Histograms
//-------------------------------------

    SaveHistograms(     //save histograms of generell results into output root file
                OutRootFileName,
                "root",
                hRootList,
                saveResults,
                verbosityLevel
                );

    if (ProduceGraphic)
    {
        UpdateCanvases(
                    verbosityLevel,
                    maxPulseOrder
                    );

        //Process gui events asynchronously during input
        cout << endl;
        TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
        timer.TurnOn();
        Getline("Press <return> to go on");
        timer.TurnOff();

        DeletePixelCanvases(
                    maxPulseOrder,
                    verbosityLevel
                    );
    }

    delete datafile;

    return( 0 );
}
//----------------------------------------------------------------------------
// end of main function
//-----------------------------------------------------------------------------




//-----------------------------------------------------------------------------
// Funktions
//-----------------------------------------------------------------------------

/*
ich erzeuge sowas wie 36 pixel mit ca 20 Histogrammen pro pixel
wie viel speicher braucht das?
Ich brauche eine möglichkeit jedes dieser histogramme zu identifizieren
am besten ein array oder eine liste oder einen abstracten datentyp mit den histogrammen als attribute.
ne klasse wäre super

*/

void BookTestHistos( int verbosityLevel )
{
    if (verbosityLevel > 2) cout << endl << "...book pixel histograms" << endl;

    hTesthisto = new TH1F (
                "hTesthisto",
                "Deviation of rising edge and maximum",
                600,
                -10.1,
                10.1
                );
    hTesthisto->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
    hTesthisto->GetYaxis()->SetTitle( "counts" );

    hTesthisto2 = new TH2F (
                "hTesthisto2",
                "Deviation of rising edge and maximum by event #",
                gNEvents,
                250,
                800,
                600,
                -10.1,
                10.1
                );
//    hTesthisto2->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
//    hTesthisto2->GetYaxis()->SetTitle( "counts" );
//    hTesthisto2->SetMarkerStyle( 2 );

    if (verbosityLevel > 2) cout << "...done" << endl;
}
//end of BookTestHistos
//----------------------------------------------------------------------------


void
BookDebugHistos( int verbosityLevel )
{
    if (verbosityLevel > 2) cout << endl << "...book histograms" << endl;
    hRootList = new TObjArray;
    debugHistos = new TH1F[ Number_Of_Debug_Histo_Types ];
    for ( int type = 0; type < Number_Of_Debug_Histo_Types; type++){
        debugHistos[ type ].SetBins(1024, 0, 1024);
        debugHistos[ type ].SetLineColor(1);
        debugHistos[ type ].SetLineWidth(2);
        debugHistos[ type ].SetStats(false);

        // set X axis paras
        debugHistos[ type ].GetXaxis()->SetLabelSize(0.08);
        debugHistos[ type ].GetXaxis()->SetTitleSize(0.08);
        debugHistos[ type ].GetXaxis()->SetTitleOffset(1.0);
        debugHistos[ type ].GetXaxis()->SetTitle(Form("Time slice [%.1f ns/slice]", 1./2.));

        // set Y axis paras
        debugHistos[ type ].GetYaxis()->SetLabelSize(0.08);
        debugHistos[ type ].GetYaxis()->SetTitleSize(0.08);
        debugHistos[ type ].GetYaxis()->SetTitleOffset(0.3);
        debugHistos[ type ].GetYaxis()->SetTitle("Amplitude [mV]");
    }
    if (verbosityLevel > 2) cout << "...done" << endl;
}
// end of BookDebugHistos
//----------------------------------------------------------------------------


void
FillHistograms(
        Pixel*          CurrentPixel,
        vector<Region>* pZXings,
        int             AmplWindowWidth,
        int             eventNumber,
        TString         histoOptions,
        int             maxPulseOrder,
        int             verbosityLevel
        )
{
    if (verbosityLevel > 2) cout << endl << "...filling pulse histograms" ;
    bool use_this_peak=false;
    int order_of_pulse=0;
    vector<Region>::iterator reg;
    //Loop over all found zerocrossings in Region
    for (reg = pZXings->begin() ; reg < pZXings->end() ; reg++)
    {
        //skip those who are at the Rim of the ROI
        if (reg->maxPos < 12 || (unsigned int) reg->maxPos > gRegionOfInterest-12)
        {
            if (verbosityLevel > 2) cout << endl << "\t...out of range" << endl;
            continue;
        }
        // Define axis range of Histogram
        int Left        = reg->maxPos - gPixelOverlayXaxisLeft;
        int Right       = reg->maxPos + gPixelOverlayXaxisRight;
        int EdgeLeft    = reg->halfRisingEdgePos - gPixelOverlayXaxisLeft;
        int EdgeRight   = reg->halfRisingEdgePos + gPixelOverlayXaxisRight;

        if (Left < 0)                           Left        =   0;
        if (EdgeLeft < 0)                       EdgeLeft    =   0;
        if (Right > (int)Ameas.size() )         Right       =   Ameas.size();
        if (EdgeRight > (int)Ameas.size() )     EdgeRight   =   Ameas.size();


//        hTesthisto2->Fill( eventNumber, reg->slopeOfRisingEdge ) ;

        if (verbosityLevel > 2) cout << endl << "\t...choosing Histogram" ;

        //determine order of pulse and which histogram shall be filled
        for(int order = 0; order < maxPulseOrder; order++)
        {
            if (Ameas[reg->maxPos] >= ((gGainMean*(order+1)) - (AmplWindowWidth/2))
                && Ameas[reg->maxPos] < ((gGainMean*(order+1)) + AmplWindowWidth/2))
            {
                if (verbosityLevel > 2) cout << "...#" << order ;
                order_of_pulse = order;
                use_this_peak = true;
                break;
            }
            else if (order >= (maxPulseOrder - 1))
            {
                use_this_peak = false;
                if (verbosityLevel > 2) cout << "...NONE" << endl ;
            }
            if (use_this_peak)
            {
                if ( histoOptions.Contains("S") )
                {
//                     if (verbosityLevel > 2)
                         cout << endl << "\t...filling Edge Histogram" ;
                    CurrentPixel->hSlopeRisingEdge[order]->Fill( reg->slopeOfRisingEdge ) ;
                }
            }
        }
        //Fill overlay und profile histograms
        if (use_this_peak){
            for ( int pos = Left; pos < Right; pos++){
//                if ();
               CurrentPixel->hMaxOverlay[order_of_pulse]->Fill( pos - (reg->maxPos), Ameas[pos]) ;
               CurrentPixel->hMaxProfile[order_of_pulse]->Fill( pos - (reg->maxPos), Ameas[pos]) ;
            }
            for ( int pos = EdgeLeft; pos < EdgeRight; pos++){
                CurrentPixel->hEdgeOverlay[order_of_pulse]->Fill( pos - (reg->halfRisingEdgePos), Ameas[pos]) ;
                CurrentPixel->hEdgeProfile[order_of_pulse]->Fill( pos - (reg->halfRisingEdgePos), Ameas[pos]) ;

            }
            if (verbosityLevel > 2) cout << "...done" << endl;
        }
        //Breakout option
        if (breakout)
        break;
   }
    if (verbosityLevel > 2) cout << "...done" << endl;
}
// end of FillHistograms
//----------------------------------------------------------------------------

void
DrawTestHistograms(
        int verbosityLevel
        )
{
    if (verbosityLevel > 2) cout << endl << "...drawing pulse histograms TODO CANVAS" ;

//    cgpTestHistos->cd(1);
//    hTesthisto->Draw();
//    cgpTestHistos->cd(2);
//    hTesthisto2->Draw("BOX");
}
// end of DrawTestHistograms
//----------------------------------------------------------------------------

void
UpdateCanvases(
        int verbosityLevel,
        int max_pulse_order
        )
{
    if (verbosityLevel > 3) cout << endl << "...updating canvases" ;
    for (int pulse_order = 0; pulse_order < max_pulse_order; pulse_order++)
    {
        cgpPixelPulses[pulse_order]->Modified();
        cgpPixelPulses[pulse_order]->Update();
        cgpTestHistos->Modified();
        cgpTestHistos->Update();
    }
}
// end of UpdateCanvases
//----------------------------------------------------------------------------

void
DeletePixelCanvases(
        int maxPulseOrder,
        int verbosityLevel
        )
{
    if (verbosityLevel > 2) cout << endl << "...delete pixel Canvases" ;
    for (int pulse_order = 0; pulse_order < maxPulseOrder; pulse_order++ )
    {
        delete cgpPixelPulses[pulse_order];
        delete cgpDistributions[pulse_order];
    }
    delete[] cgpPixelPulses;
    delete[] cgpDistributions;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

void
ProduceDebugHistos(
        vector<Region>* pZXings
        )
{
    // TODO do this correct. The vectors should be the rigt ones... this is just luck
    debugHistos[Ameas_].GetXaxis()->Set(Ameas.size() , -0.5 , Ameas.size()-0.5);
    debugHistos[Vcorr_].GetXaxis()->Set(Ameas.size() , -0.5 , Ameas.size()-0.5);
    debugHistos[Vslide_].GetXaxis()->Set(Ameas.size() , -0.5 , Ameas.size()-0.5);
    debugHistos[Vcfd_].GetXaxis()->Set(Ameas.size() , -0.5 , Ameas.size()-0.5);
    debugHistos[Vcfd2_].GetXaxis()->Set(Ameas.size() , -0.5 , Ameas.size()-0.5);

    for ( unsigned int sl = 0; sl < gRegionOfInterest; sl++)
    {
       debugHistos[Ameas_].SetBinContent(sl, Ameas[sl]);
       debugHistos[Vcorr_].SetBinContent(sl, Vcorr[sl]);
       debugHistos[Vslide_].SetBinContent( sl, Vslide[sl] );
       debugHistos[Vcfd_].SetBinContent( sl, Vcfd[sl] );
       debugHistos[Vcfd2_].SetBinContent( sl, Vcfd2[sl] );
    }


    cFiltered->cd(1);
    gPad->SetGrid();
    debugHistos[Ameas_].Draw();

    cFiltered->cd(2);
    gPad->SetGrid();
    debugHistos[Vcorr_].Draw();

    cFiltered->cd(3);
    gPad->SetGrid();
    debugHistos[Vslide_].Draw();

    TBox *OneBox;
    vector<TBox*> MyBoxes;
    for (unsigned int i=0; i<pZXings->size(); i++){
            OneBox = new TBox(
                    pZXings->at(i).maxPos -10 ,
                    pZXings->at(i).maxVal -0.5,
                    pZXings->at(i).maxPos +10 ,
                    pZXings->at(i).maxVal +0.5);
            OneBox->SetLineColor(kBlue);
            OneBox->SetLineWidth(1);
            OneBox->SetFillStyle(0);
            OneBox->SetFillColor(kRed);
            MyBoxes.push_back(OneBox);
            OneBox->Draw();
    }

//            cFiltered->cd(3);
//            gPad->SetGrid();
//            debugHistos[Vcfd2_].Draw();
//            TLine *zeroline = new TLine(0, 0, 1024, 0);
//            zeroline->SetLineColor(kBlue);
//            zeroline->Draw();

    cFiltered->Update();


    //Process gui events asynchronously during input
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    timer.TurnOn();
    TString input = Getline("Type 'q' to exit, <return> to go on: ");
    timer.TurnOff();
    if (input=="q\n") {
            breakout=true;
    }

    //TODO!!!!!!!!!
    // do some Garbage collection ...
    // all the Objects on the heap should be deleted here.

}// end of if(spikeDebug)


int main()
{

FPulseOverlay();
return 0;

}
