#include <iostream>
#include "TObjArray.h"
#include "TCanvas.h"

#include "rootfilehandler.h"
#include "pixel.h" // class implemented
using namespace std;

/////////////////////////////// PUBLIC ///////////////////////////////////////

//============================= LIFECYCLE ====================================

//Pixel::Pixel(int pixelID)
//{
//    Chid                                = pixelID;
//    max_puslse_order                    = 1;
//    hMaxOverlay                       = NULL;
//    hEdgeOverlay                   = NULL;
//    hMaxProfile                       = NULL;
//    hEdgeProfile                      = NULL;
//    hList                               = NULL;

//}

Pixel::Pixel(
        int         pixelID,
        int         maxPulsorder,
        int         verbosityLevel,
        int         pixelOverlayXaxisLeft,
        int         pixelOverlayXaxisRight,
        int         bSLMean,
        int         gainMean,
        TString     options
        )
{
    mChid                   = pixelID;
    mMaxPulseOrder          = maxPulsorder;
    mVerbosityLevel         = verbosityLevel;
    mOptions                = options;
    mPixelOverlayXaxisLeft  = pixelOverlayXaxisLeft;
    mPixelOverlayXaxisRight = pixelOverlayXaxisRight;
    mBSLMean                = bSLMean;
    mGainMean               = gainMean;

    hMaxOverlay  = new TH2F*[mMaxPulseOrder];
    hEdgeOverlay = new TH2F*[mMaxPulseOrder];
    hMaxProfile  = new TProfile*[mMaxPulseOrder];
    hEdgeProfile = new TProfile*[mMaxPulseOrder];

    if (mOptions.Contains("S") )
    {
        hSlopeRisingEdge = new TH1F*[mMaxPulseOrder];
    }

    if (mOptions.Contains("R") )
    {
        hRisingEdgeToMax = new TH1F*[mMaxPulseOrder];
    }

    if (mOptions.Contains("M") )
    {
        hPosOfMax = new TH1F*[mMaxPulseOrder];
    }

    hList           = new TObjArray;

    BookPixelHistos();
    BookDistributionHistos();
}

Pixel::~Pixel()
{
    if (mVerbosityLevel > 1) cout << endl << "...delete histograms of pixel " << mChid ;

    DeletePixelHistos();
    DeleteDistributionHistos();

    delete hList;
    hList = NULL;

}// ~Pixel


//============================= OPERATORS ====================================

//XX&
//XX::operator=(const XX&);
//{
//    return *this;

//}// =

//============================= OPERATIONS ===================================
void
Pixel::BookPixelHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...book pixel histograms" << endl;
    TString histo_name;
    TString histo_title;

    for (int order = 0; order < mMaxPulseOrder; order++)
    {
        histo_name =    "hMaxOverlay";
        histo_name +=   mChid;
        histo_name +=   "_";
        histo_name +=   order;

        histo_title =   "Overlay of detected pulses of one pulse order for one Pixel ";
        histo_title +=   "[Pixel_Order] ";
        histo_title +=  mChid;
        histo_title +=   "_";
        histo_title +=   order;

        if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
        hMaxOverlay[order]=new TH2F(
                histo_name,
                histo_title,
                mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                (-1*mPixelOverlayXaxisLeft)-0.5,
                mPixelOverlayXaxisRight-0.5 ,
                512,
                -55.5,
                200.5
                );
/*
                SetHistogramAttributes(
                            "PeakMaxGaus",
                            order,
                            gMaxGausAttrib,
                            MaxAmplOfFirstPulse
                            );
                            */
        hMaxOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hMaxOverlay[order] );

//------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name =    "hEdgeOverlay";
        histo_name +=   mChid;
        histo_name +=   "_";
        histo_name +=   order;

        histo_title =   "Overlay at rising edge of detected pulses of one pulse order for one Pixel ";
        histo_title +=   "[Pixel_Order] ";
        histo_title +=  mChid;
        histo_title +=   "_";
        histo_title +=   order;

        if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
        hEdgeOverlay[order] = new TH2F(
                    histo_name,
                    histo_title,
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                    (-1*mPixelOverlayXaxisLeft)-0.5,
                    mPixelOverlayXaxisRight-0.5 ,
                    512,
                    -55.5,
                    200.5
                    );

        hEdgeOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        hList->Add( hEdgeOverlay[order] );

    //------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name =    "hMaxProfile";
        histo_name +=   mChid;
        histo_name +=   "_";
        histo_name +=   order;

        histo_title =   "Mean value of each slice in overlay plot (Tprofile) ";
        histo_title +=   "[Pixel_Order] ";
        histo_title +=  mChid;
        histo_title +=   "_";
        histo_title +=   order;

        if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
        hMaxProfile[order] = new TProfile(
                    histo_name,
                    histo_title,
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hMaxProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hMaxProfile[order] );


    //------------------------------------------------------------------------
/*
        SetHistogramAttributes(
                    "PeakMaxGaus",
                    order,
                    gMaxGausAttrib,
                    MaxAmplOfFirstPulse
                    );
                    */
        histo_name = "hEdgeProfile";
        histo_name +=   mChid;
        histo_name +=   "_";
        histo_name += order;

        histo_title =   "Mean value of each slice in overlay plot (Tprofile) ";
        histo_title +=   "[Pixel_Order] ";
        histo_title +=  mChid;
        histo_title +=   "_";
        histo_title +=   order;

        if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
        hEdgeProfile[order] = new TProfile(
                    histo_name,
                    histo_title,
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hEdgeProfile[order]->SetLineColor(kRed);
        hEdgeProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hList->Add( hEdgeProfile[order] );

    }
    if (mVerbosityLevel > 2) cout << "...done" << endl;
}
//end of BookPixelHistos
//----------------------------------------------------------------------------


void
Pixel::DrawHistograms(
        TCanvas**    pixelCanvas,
        int*        histoFrameNr
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing pulse histograms" ;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        pixelCanvas[pulse_order]->cd( histoFrameNr[0] );
        hMaxOverlay[pulse_order]->Draw("COLZ");
        pixelCanvas[pulse_order]->cd( histoFrameNr[2] );
        hMaxProfile[pulse_order]->Draw();
        hEdgeProfile[pulse_order]->Draw("SAME");

        pixelCanvas[pulse_order]->cd( histoFrameNr[1] );
        hEdgeOverlay[pulse_order]->Draw("COLZ");
    }
}
// end of DrawPulseHistograms
//----------------------------------------------------------------------------


void
Pixel::BookDistributionHistos( )
{
    if (!mOptions.IsNull() )
    {
        TString histo_name;
        TString histo_title;
        for (int order =0; order < mMaxPulseOrder; order++)
        {
            if (mVerbosityLevel > 2) cout << endl
                                          << "...book distribution histograms"
                                          << endl;

            if (mOptions.Contains("S"))
            {
                histo_name =    "hSlopeRisingEdge";
                histo_name +=   mChid;
                histo_name +=   "_";
                histo_name +=   order;
                histo_title =   "Distribution of rising edge [Pixel_Order]";
                histo_title +=  mChid;
                histo_title +=   "_";
                histo_title +=   order;
                if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
                hSlopeRisingEdge[order] = new TH1F (
                            histo_name,
                            histo_title,
                            600,
                            -10.1,
                            10.1
                            );
                hSlopeRisingEdge[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hSlopeRisingEdge[order]->GetYaxis()->SetTitle( "counts" );
                hList->Add( hSlopeRisingEdge[order] );
            }

            if (mOptions.Contains("R"))
            {
                histo_name =    "hRisingEdgeToMax";
                histo_name +=   mChid;
                histo_name +=   "_";
                histo_name +=    order;
                histo_title =   "Deviation of rising edge and maximum [Pixel_Order]";
                histo_title +=  mChid;
                histo_title +=   "_";
                histo_title +=   order;
                if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
                hRisingEdgeToMax[order] = new TH1F (
                            histo_name,
                            histo_title,
                            600,
                            -10.1,
                            10.1
                            );
                hRisingEdgeToMax[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hRisingEdgeToMax[order]->GetYaxis()->SetTitle( "counts" );
                hList->Add( hRisingEdgeToMax[order] );
            }

            if (mOptions.Contains("M"))
            {
                histo_name =    "hPosOfMax";
                histo_name +=   mChid;
                histo_name +=   "_";
                histo_name +=   order;
                histo_title =   "Deviation of rising edge and maximum [Pixel_Order]";
                histo_title +=  mChid;
                histo_title +=   "_";
                histo_title +=   order;
                if (mVerbosityLevel > 3) cout << "\t...booking " << histo_name << endl;
                hPosOfMax[order] = new TH1F (
                            histo_name,
                            histo_title,
                            600,
                            -10.1,
                            10.1
                            );
                hPosOfMax[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hPosOfMax[order]->GetYaxis()->SetTitle( "counts" );
                hList->Add( hPosOfMax[order] );
            }

            if (mVerbosityLevel > 2) cout << "...done" << endl;
        }
    }
}

void
Pixel::DrawDistributionHistograms(
        TCanvas**    pixelCanvas,
        int*        histoFrameNr
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing distribution histograms" ;
    bool nothing_to_fill = true;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        if (mOptions.Contains("S") )
        {
        pixelCanvas[pulse_order]->cd( histoFrameNr[0] );
        hSlopeRisingEdge[pulse_order]->Draw();
        nothing_to_fill = false;
        }

        if (mOptions.Contains("R") )
        {
        pixelCanvas[pulse_order]->cd( histoFrameNr[1] );
        hRisingEdgeToMax[pulse_order]->Draw();
        nothing_to_fill = false;
        }

        if (mOptions.Contains("M") )
        {
        pixelCanvas[pulse_order]->cd( histoFrameNr[2] );
        hPosOfMax[pulse_order]->Draw();
        nothing_to_fill = false;
        }

    }
    if (nothing_to_fill)
    {
        cout << "there were NO DISTRIBUTION HISTOGRAMS to fill"
    }
}
// end of DrawDistributionHistograms
//----------------------------------------------------------------------------

void
Pixel::SavePixelHistograms(
        const char* outRootFileName,
        bool        saveResults
        )
{
    if (mVerbosityLevel > 2) cout << endl << "Saving histograms of Pixel# " << mChid;
    if (!saveResults) return;
    SaveHistograms(
            outRootFileName,
            CreateSubDirName( mChid ),
            hList,
            saveResults,
            mVerbosityLevel
            );
}
// end of SavePixelHistograms
//----------------------------------------------------------------------------

void
Pixel::DeletePixelHistos()
{
    if (mVerbosityLevel > 2)
    {
        cout << endl
             << "\t...delete current overlay histograms of Pixel# " << mChid;
    }
    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mVerbosityLevel > 3)
        cout << endl << "\t\t...deleting hMaxOverlay"
                                      << mChid << "_" << order
                                      << " hMaxOverlay[order] adr " << hMaxOverlay[order]
                                      << " hMaxOverlay adr " << hMaxOverlay
                                         ;

        delete hMaxOverlay[order];
        hMaxOverlay[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hEdgeOverlay"
                                      << mChid << "_" << order ;
        delete hEdgeOverlay[order];
        hEdgeOverlay[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxProfile"
                                      << mChid << "_" << order ;
        delete hMaxProfile[order];
        hMaxProfile[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxProfile2"
                                      << mChid << "_" << order ;
        delete hEdgeProfile[order];
        hEdgeProfile[order] = NULL;
    }
    if (mVerbosityLevel > 3) cout << endl << "\t...deleting histogram Arrays";

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxOverlay";
    delete[] hMaxOverlay;
    hMaxOverlay = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hEdgeOverlay";
    delete[] hEdgeOverlay;
    hEdgeOverlay = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxProfile";
    delete[] hMaxProfile;
    hMaxProfile = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hEdgeProfile";
    delete[] hEdgeProfile;
    hEdgeProfile = NULL;
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

void
Pixel::DeleteDistributionHistos()
{
    if (mVerbosityLevel > 2)
    {
        cout << endl
             << "\t...delete current distribution histograms" ;
    }

    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mOptions.Contains("S"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting hSlopeRisingEdge"
                                          << mChid << "_" << order ;
            delete hSlopeRisingEdge[order];
        }

        if (mOptions.Contains("R"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting hRisingEdgeToMax"
                                          << mChid << "_" << order ;
//            delete hRisingEdgeToMax[order];
        }

        if (mOptions.Contains("M"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting hPosOfMax"
                                          << mChid << "_" << order ;

//            delete hPosOfMax[order];
        }

    }
    if (mVerbosityLevel > 3) cout << endl << "\t...deleting histogram Arrays";

    if (mOptions.Contains("S"))
    {
        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hSlopeRisingEdge";
        delete[] hSlopeRisingEdge;
        hSlopeRisingEdge = NULL;
    }

    if (mOptions.Contains("R"))
    {
        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hRisingEdgeToMax";
        delete[] hRisingEdgeToMax;
        hRisingEdgeToMax = NULL;
    }

    if (mOptions.Contains("M"))
    {
        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hPosOfMax";
        delete[] hPosOfMax;
        hPosOfMax = NULL;
    }
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

//============================= ACESS      ===================================
//============================= INQUIRY    ===================================
/////////////////////////////// PROTECTED  ///////////////////////////////////

/////////////////////////////// PRIVATE    ///////////////////////////////////








