#include <iostream>
#include "TObjArray.h"
#include "TCanvas.h"

#include "rootfilehandler.h"
#include "pixel.h" // class implemented
using namespace std;

/////////////////////////////// PUBLIC ///////////////////////////////////////

//============================= LIFECYCLE ====================================

//Pixel::Pixel(int pixelID)
//{
//    Chid                                = pixelID;
//    max_puslse_order                    = 1;
//    hMaxOverlay                       = NULL;
//    hEdgeOverlay                   = NULL;
//    hMaxProfile                       = NULL;
//    hEdgeProfile                      = NULL;
//    hList                               = NULL;

//}
//Pixel::Pixel(
//        int         pixelID,
//        int         maxPulsorder,
//        int         verbosityLevel,
//        bool        stats,
//        TFile*      filename
//        )
//{
//    mChid                   = pixelID;
//    mStats                  = stats;
//    mMaxPulseOrder          = maxPulsorder;
//    mVerbosityLevel         = verbosityLevel;

//    hMaxOverlay  = new TH2F*[mMaxPulseOrder];
//    hEdgeOverlay = new TH2F*[mMaxPulseOrder];
//    hMaxProfile  = new TProfile*[mMaxPulseOrder];
//    hEdgeProfile = new TProfile*[mMaxPulseOrder];

//    hList           = new TObjArray;

//    LoadPulseHistos( filename );
//}

Pixel::Pixel(
        int         pixelID,
        int         maxPulsorder,
        int         verbosityLevel,
        bool        stats,
//        TFile*      filename,
        int         pixelOverlayXaxisLeft,
        int         pixelOverlayXaxisRight,
        int         bSLMean,
        int         gainMean,
        TString     options
        )
{
    mChid                   = pixelID;
    mStats                  = stats;        ///TODO: HANDOVER THE VALUE
    mMaxPulseOrder          = maxPulsorder;
    mVerbosityLevel         = verbosityLevel;
    mOptions                = options;
    mPixelOverlayXaxisLeft  = pixelOverlayXaxisLeft;
    mPixelOverlayXaxisRight = pixelOverlayXaxisRight;
    mBSLMean                = bSLMean;
    mGainMean               = gainMean;

    hMaxOverlay  = new TH2F*[mMaxPulseOrder];
    hEdgeOverlay = new TH2F*[mMaxPulseOrder];
    hMaxProfile  = new TProfile*[mMaxPulseOrder];
    hEdgeProfile = new TProfile*[mMaxPulseOrder];

    if (mOptions.Contains("S") )
    {
        hSlopeRisingEdge = new TH1F*[mMaxPulseOrder];
    }

    if (mOptions.Contains("R") )
    {
        hRisingEdgeToMax = new TH1I*[mMaxPulseOrder];
    }

    if (mOptions.Contains("M") )
    {
        hPosOfMax = new TH1I*[mMaxPulseOrder];
    }

    hList           = new TObjArray;

    BookPixelHistos();
    BookDistributionHistos();
}

Pixel::~Pixel()
{
    if (mVerbosityLevel > 1) cout << endl << "...delete histograms of pixel " << mChid ;

    DeletePixelHistos();
    DeleteDistributionHistos();

    delete hList;
    hList = NULL;

}// ~Pixel


//============================= OPERATORS ====================================

//XX&
//XX::operator=(const XX&);
//{
//    return *this;

//}// =

//============================= OPERATIONS ===================================
void
Pixel::BookPixelHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...book pixel histograms" << endl;
    for (int order = 0; order < mMaxPulseOrder; order++)
    {
        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hMaxOverlay", order) << endl;
        hMaxOverlay[order]=new TH2F(
                    HistoName("hMaxOverlay", order),
                    HistoTitle("Overlay of detected pulses of", order),
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                    (-1*mPixelOverlayXaxisLeft)-0.5,
                    mPixelOverlayXaxisRight-0.5 ,
                    512,
                    -55.5,
                    200.5
                    );

        hMaxOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hMaxOverlay[order]->SetStats(mStats);
        hList->Add( hMaxOverlay[order] );

//------------------------------------------------------------------------

        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hEdgeOverlay", order) << endl;
        hEdgeOverlay[order] = new TH2F(
                    HistoName("hEdgeOverlay", order),
                    HistoTitle("Overlay at rising edge of detected pulses of", order),
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,
                    (-1*mPixelOverlayXaxisLeft)-0.5,
                    mPixelOverlayXaxisRight-0.5 ,
                    512,
                    -55.5,
                    200.5
                    );

        hEdgeOverlay[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeOverlay[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeOverlay[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        hEdgeOverlay[order]->SetStats(mStats);
        hList->Add( hEdgeOverlay[order] );

    //------------------------------------------------------------------------

        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hMaxProfile", order) << endl;
        hMaxProfile[order] = new TProfile(
                    HistoName("hMaxProfile", order),
                    HistoTitle("Mean value of each slice in overlay plot (Tprofile)", order),
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hMaxProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hMaxProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hMaxProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hMaxProfile[order]->SetStats(mStats);
        hList->Add( hMaxProfile[order] );


    //------------------------------------------------------------------------

        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hEdgeProfile", order) << endl;
        hEdgeProfile[order] = new TProfile(
                    HistoName("hEdgeProfile", order),
                    HistoTitle("Mean value of each slice in overlay plot (Tprofile)", order),
                    mPixelOverlayXaxisLeft + mPixelOverlayXaxisRight ,//nbinsx
                    (-1*mPixelOverlayXaxisLeft)-0.5,                 //xlow
                    mPixelOverlayXaxisRight-0.5 ,                    //xup
    //                512,                                            //nbinsy
                    -55.5,                                          //ylow
                    300.5,                                          //yup
                    "s");                                           //option
        hEdgeProfile[order]->SetLineColor(kRed);
        hEdgeProfile[order]->SetAxisRange(
                    mBSLMean - 5,
                    (mGainMean*(order+1)) + 10,
                    "Y");
        hEdgeProfile[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
        hEdgeProfile[order]->GetYaxis()->SetTitle( "Amplitude [mV]" );
        //hMaxProfile->SetBit(TH2F::kCanRebin);
        hEdgeProfile[order]->SetStats(mStats);
        hList->Add( hEdgeProfile[order] );

    }
    if (mVerbosityLevel > 2) cout << "...done" << endl;
}
//end of BookPixelHistos
//----------------------------------------------------------------------------


void
Pixel::DrawHistograms(
        TCanvas**    pixelCanvas,
        int*        histoFrameNr
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing pulse histograms" ;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        pixelCanvas[pulse_order]->cd( histoFrameNr[0] );
        hMaxOverlay[pulse_order]->Draw("COLZ");
        pixelCanvas[pulse_order]->cd( histoFrameNr[2] );
        hMaxProfile[pulse_order]->Draw();
        hEdgeProfile[pulse_order]->Draw("SAME");

        pixelCanvas[pulse_order]->cd( histoFrameNr[1] );
        hEdgeOverlay[pulse_order]->Draw("COLZ");
    }
}
// end of DrawPulseHistograms
//----------------------------------------------------------------------------


void
Pixel::BookDistributionHistos( )
{
    if (!mOptions.IsNull() )
    {
        int x_min = 0;
        int x_max = 0;

        for (int order =0; order < mMaxPulseOrder; order++)
        {
            if (mVerbosityLevel > 2) cout << endl
                                          << "...book distribution histograms"
                                          << endl;

            if (mOptions.Contains("S"))
            {
                if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hSlopeRisingEdge", order) << endl;
                hSlopeRisingEdge[order] = new TH1F (
                            HistoName("hSlopeRisingEdge", order),
                            HistoTitle("Distribution of rising edge's slope", order),
                            600,
                            -10.1,
                            10.1
                            );
                hSlopeRisingEdge[order]->SetAxisRange(
                                    -1,
                                    7,
                                    "X");
                hSlopeRisingEdge[order]->GetXaxis()->SetTitle( "Slope Amplitude/time [mV/timeslices]" );
                hSlopeRisingEdge[order]->GetYaxis()->SetTitle( "counts" );
                hSlopeRisingEdge[order]->SetStats(mStats);
                hList->Add( hSlopeRisingEdge[order] );
            }

            if (mOptions.Contains("R"))
            {
                x_min = -15;
                x_max = 35;

                if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hRisingEdgeToMax", order) << endl;
                hRisingEdgeToMax[order] = new TH1I (
                            HistoName("hRisingEdgeToMax", order),
                            HistoTitle("Distance from rising edge to pulse's maximum", order),
                            x_max -x_min,
                            x_min,
                            x_max
                            );
                hSlopeRisingEdge[order]->SetAxisRange(
                                    -5,
                                    25,
                                    "X");
                hRisingEdgeToMax[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hRisingEdgeToMax[order]->GetYaxis()->SetTitle( "counts" );
                hRisingEdgeToMax[order]->SetStats(mStats);
                hList->Add( hRisingEdgeToMax[order] );
            }

            if (mOptions.Contains("M"))
            {
                x_min = 10;
                x_max = 290;
                if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("hPosOfMax", order) << endl;
                hPosOfMax[order] = new TH1I (
                            HistoName("hPosOfMax", order),
                            HistoTitle("Distribution of pulse's maximum's positon", order),
                            x_max - x_min,
                            x_min,
                            x_max
                            );
                hPosOfMax[order]->GetXaxis()->SetTitle( "Timeslices [a.u.]" );
                hPosOfMax[order]->GetYaxis()->SetTitle( "counts" );
                hRisingEdgeToMax[order]->SetStats(mStats);
                hList->Add( hPosOfMax[order] );
            }

            if (mVerbosityLevel > 2) cout << "...done" << endl;
        }
    }
}

void
Pixel::DrawDistributionHistograms(
        TCanvas**    pixelCanvas,
        int*        histoFrameNr
        )
{
    if (mVerbosityLevel > 2) cout << endl << "...drawing distribution histograms" ;
    bool nothing_to_fill = true;
    for (int pulse_order = 0; pulse_order < mMaxPulseOrder; pulse_order++)
    {
        if (mOptions.Contains("S") )
        {
        pixelCanvas[pulse_order]->cd( histoFrameNr[0] );
        hSlopeRisingEdge[pulse_order]->Draw();
        nothing_to_fill = false;
        }

        if (mOptions.Contains("R") )
        {
        pixelCanvas[pulse_order]->cd( histoFrameNr[1] );
        hRisingEdgeToMax[pulse_order]->Draw();
        nothing_to_fill = false;
        }

        if (mOptions.Contains("M") )
        {
        pixelCanvas[pulse_order]->cd( histoFrameNr[2] );
        hPosOfMax[pulse_order]->Draw();
        nothing_to_fill = false;
        }

    }
    if (nothing_to_fill)
    {
        cout << endl << "there were NO DISTRIBUTION HISTOGRAMS to fill" << endl;
    }
}
// end of DrawDistributionHistograms
//----------------------------------------------------------------------------

void
Pixel::SavePixelHistograms(
        const char* outRootFileName,
        bool        saveResults
        )
{
    if (mVerbosityLevel > 2) cout << endl << "Saving histograms of Pixel# " << mChid;
    if (!saveResults) return;
    SaveHistograms(
            outRootFileName,
            CreateSubDirName( mChid ),
            hList,
            saveResults,
            mVerbosityLevel
            );
}
// end of SavePixelHistograms
//----------------------------------------------------------------------------

void
Pixel::DeletePixelHistos()
{
    if (mVerbosityLevel > 2)
    {
        cout << endl
             << "\t...delete current overlay histograms of Pixel# " << mChid;
    }
    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mVerbosityLevel > 3)
        cout << endl << "\t\t...deleting hMaxOverlay"
                                      << mChid << "_" << order
                                      << " hMaxOverlay[order] adr " << hMaxOverlay[order]
                                      << " hMaxOverlay adr " << hMaxOverlay
                                         ;

        delete hMaxOverlay[order];
        hMaxOverlay[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hEdgeOverlay"
                                      << mChid << "_" << order ;
        delete hEdgeOverlay[order];
        hEdgeOverlay[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxProfile"
                                      << mChid << "_" << order ;
        delete hMaxProfile[order];
        hMaxProfile[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxProfile2"
                                      << mChid << "_" << order ;
        delete hEdgeProfile[order];
        hEdgeProfile[order] = NULL;
    }
    if (mVerbosityLevel > 3) cout << endl << "\t...deleting histogram Arrays";

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxOverlay";
    delete[] hMaxOverlay;
    hMaxOverlay = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hEdgeOverlay";
    delete[] hEdgeOverlay;
    hEdgeOverlay = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hMaxProfile";
    delete[] hMaxProfile;
    hMaxProfile = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hEdgeProfile";
    delete[] hEdgeProfile;
    hEdgeProfile = NULL;
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

void
Pixel::DeleteDistributionHistos()
{
    if (mVerbosityLevel > 2)
    {
        cout << endl
             << "\t...delete current distribution histograms" ;
    }

    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mOptions.Contains("S"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting hSlopeRisingEdge"
                                          << mChid << "_" << order ;
            delete hSlopeRisingEdge[order];
        }

        if (mOptions.Contains("R"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting hRisingEdgeToMax"
                                          << mChid << "_" << order ;
//            delete hRisingEdgeToMax[order];
        }

        if (mOptions.Contains("M"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting hPosOfMax"
                                          << mChid << "_" << order ;

//            delete hPosOfMax[order];
        }

    }
    if (mVerbosityLevel > 3) cout << endl << "\t...deleting histogram Arrays";

    if (mOptions.Contains("S"))
    {
        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hSlopeRisingEdge";
        delete[] hSlopeRisingEdge;
        hSlopeRisingEdge = NULL;
    }

    if (mOptions.Contains("R"))
    {
        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hRisingEdgeToMax";
        delete[] hRisingEdgeToMax;
        hRisingEdgeToMax = NULL;
    }

    if (mOptions.Contains("M"))
    {
        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting hPosOfMax";
        delete[] hPosOfMax;
        hPosOfMax = NULL;
    }
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

void
Pixel::LoadPulseHistos(
        TFile*      filename
        )
{
    filename->cd();
    filename->cd(CreateSubDirName( mChid ));
    for (int order = 0; order < mMaxPulseOrder; order++)
    {
        hMaxOverlay[order]  = (TH2F*)filename->Get( HistoName("hMaxOverlay", order) );
        hEdgeOverlay[order] = (TH2F*)filename->Get( HistoName("hEdgeOverlay", order) );
        hMaxProfile[order]  = (TProfile*)filename->Get( HistoName("hMaxProfile", order) );
        hEdgeProfile[order] = (TProfile*)filename->Get( HistoName("hEdgeProfile", order) );
    }
}

TString
Pixel::HistoName(
        TString     histoname,
        int         order
        )
{
    histoname +=   mChid;
    histoname +=   "_";
    histoname +=   order;
    return histoname;
}

TString
Pixel::HistoTitle(
        TString     histo_title,
        int         order
        )
{
    histo_title +=   " [Pixel_Order] ";
    histo_title +=   mChid;
    histo_title +=   "_";
    histo_title +=   order;
    return histo_title;
}


//============================= ACESS      ===================================
//============================= INQUIRY    ===================================
/////////////////////////////// PROTECTED  ///////////////////////////////////

/////////////////////////////// PRIVATE    ///////////////////////////////////








