/**  A one line description of the class.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see something
 */

#ifndef PIXEL_H
#define PIXEL_H

// SYSTEM INCLUDES

#include <TROOT.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TString.h>

//

// PROJECT INCLUDES
//
//#include "rootfilehandler.h"
//#include "rootfilehandler.C"

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//


class Pixel
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    Pixel(
            int     pixelID,
            int     maxPulsorder,
            int     verbosityLevel,
            bool    stats,
            TFile*  filename
            );

    Pixel(
            int     pixelID,
            int     maxPulsorder,
            int     verbosityLevel,
            bool    stats,
            TFile*  filename,
            int     pixelOverlayXaxisLeft,
            int     pixelOverlayXaxisRight,
            int     bSLMean,
            int     gainMean,
            TString options
        );


    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */


    /** Destructor.
    */
    ~Pixel();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS

    void BookPixelHistos();
    void DeletePixelHistos();
    void DrawHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNR   //Array with Canvas Frame numbers
            );

    //Distributions
    void BookDistributionHistos();
    void DeleteDistributionHistos();
    void DrawDistributionHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );

    void BookTemplateHistos();
    void DeleteTemplateHistos();

    //File Handling
    void SavePixelHistograms(const char *loc_fname, bool);
    void LoadPulseHistos( );

    TString HistoTitle(
            TString     histo_title,
            int         order
            );

    TString HistoName(
            TString     histoname,
            int         order
            );

// ACCESS
// INQUIRY
    int             mChid;
    bool            mStats;
    int             mMaxPulseOrder;
    int             mVerbosityLevel;
    int             mPixelOverlayXaxisLeft;
    int             mPixelOverlayXaxisRight;
    int             mBSLMean;
    int             mGainMean;
    TString         mOptions;

    //Pixel Histos
    TH2F**          hMaxOverlay;      //histogrammm for overlay of detected Peaks
    TH2F**          hEdgeOverlay;
    TProfile**      hMaxProfile;      //histogrammm for Profile of detected Peaks
    TProfile**      hEdgeProfile;  //histogrammm for Profile of detected Peaks

    //Distribution Histos
    TH1F**          hSlopeRisingEdge;
    TH1I**          hRisingEdgeToMax;
    TH1I**          hPosOfMax;

    //Template Histos
    TH1F**          hPixelMax;
    TH1F**          hPixelMedian;
    TH1F**          hPixelMean;

    TObjArray*      hList;

    TFile*          mRootFile;

protected:
    int             mConstructorType;
private:
};

// INLINE METHODS
//

// EXTERNAL REFERENCES
//

#endif  // _PIXEL_H_
