/**  A one line description of the class.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see something
 */

#ifndef PIXEL_H
#define PIXEL_H

// SYSTEM INCLUDES

#include <TROOT.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TString.h>

//

// PROJECT INCLUDES
//
//#include "rootfilehandler.h"
//#include "rootfilehandler.C"

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//


class Pixel
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    Pixel(
            int     pixelID,
            int     maxPulsorder,
            int     verbosityLevel,
            bool    stats,
            TFile*  filename
            );

    Pixel(
            int     pixelID,
            int     maxPulsorder,
            int     verbosityLevel,
            bool    stats,
            TFile*  filename,
            int     pixelOverlayXaxisLeft,
            int     pixelOverlayXaxisRight,
            int     bSLMean,
            int     gainMean,
            TString options
        );


    //    /** Copy constructor.
    //    *
    //    * @param from The value to copy to this object.
    //    */


    /** Destructor.
    */
    ~Pixel();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS

    //Histogram Booking
    void BookPixelHistos();
    void BookDistributionHistos();
    void BookTemplateHistos();
    void BookEdgeTemplateHistos();

    //Histogram Drawing
    void DrawOverlayHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNR   //Array with Canvas Frame numbers
            );
    void DrawDistributionHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );
    void DrawTemplateHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );
    void DrawEdgeTemplateHistograms(
            TCanvas     **pixelCanvas,   //Array of Canvases
            int         *histoFrameNr   //Array with Canvas Frame numbers
            );

    //Histogram deletion
    void DeletePixelHistos();
    void DeleteDistributionHistos();
    void DeleteTemplateHistos();
    void DeleteEdgeTemplateHistos();

    //File Handling
    void SavePixelHistograms(const char *loc_fname, bool);
    void LoadPulseHistos( );

    //File Handling Service Functions
    TString HistoTitle(TString, int );
    TString HistoName(TString, int);

// ACCESS
// INQUIRY
    int             mChid;
    bool            mStats;
    int             mMaxPulseOrder;
    int             mVerbosityLevel;
    int             mPixelOverlayXaxisLeft;
    int             mPixelOverlayXaxisRight;
    int             mBSLMean;
    int             mGainMean;
    TString         mOptions;

    //Pixel Histos
    TH2F**          hMaxOverlay;      //histogrammm for overlay of detected Peaks
    TH2F**          hEdgeOverlay;
    TProfile**      hMaxProfile;      //histogrammm for Profile of detected Peaks
    TProfile**      hEdgeProfile;  //histogrammm for Profile of detected Peaks

    //Distribution Histos
    TH1F**          hSlopeRisingEdge;
    TH1I**          hRisingEdgeToMax;
    TH1I**          hPosOfMax;

    //Max Overlay Template Histos
    TH1F**          hPixelMax;
    TH1F**          hPixelMedian;
    TH1F**          hPixelMean;
    //Edge OverlayTemplate Histos
    TH1F**          hPixelEdgeMax;
    TH1F**          hPixelEdgeMedian;
    TH1F**          hPixelEdgeMean;

    TObjArray*      hList;

    TFile*          mRootFile;

protected:
    int             mConstructorType;
private:
};

// INLINE METHODS
//

// EXTERNAL REFERENCES
//

#endif  // _PIXEL_H_
