#ifndef MARS_MParticle
#define MARS_MParticle

#ifndef ROOT_TObject
#include <TObject.h>
#endif

/*
 #ifndef MARS_MParContainer
 #include "MParContainer.h"
 #endif
 */

class MParticle : public TObject
{
public:
    typedef enum { kEGamma, kEElectron, kEPositron } ParticleType_t;
    enum { kEIsPrimary = BIT(14) };

private:
    const ParticleType_t fPType; //! Particle type

protected:
    Double_t fEnergy; // [GeV] Energy

    Double_t fZ;      // [1]   Red shift
    Double_t fR;      // [kpc] Radius from line of view
    Double_t fPhi;    // [rad] Phi@z from line of view

    Double_t fTheta;  // [rad] Direction of momentum, angle || line of view
    Double_t fPsi;    // [rad] Direction of momentum, az. angle

public:
    MParticle(ParticleType_t t, const char *name=NULL, const char *title=NULL);

    static Double_t ZofR(Double_t *x, Double_t *k=NULL);
    static Double_t RofZ(Double_t *x, Double_t *k=NULL);

    void operator=(MParticle &p)
    {
        fZ = p.fZ;
        fR = p.fR;
        fPhi = p.fPhi;
        fTheta = p.fTheta;
        fPsi = p.fPsi;
    }

    void SetIsPrimary(Bool_t is=kTRUE) { is ? SetBit(kEIsPrimary) : ResetBit(kEIsPrimary); }
    Bool_t IsPrimary() const { return TestBit(kEIsPrimary); }

    // ----------------------------------------------------------------

    virtual Double_t GetInteractionLength() const = 0;

    void SetEnergy(Double_t e) { fEnergy = e; }
    void SetZ(Double_t z)      { fZ = z; }

    void SetNewDirection(Double_t theta, Double_t phi);
    Bool_t SetNewPosition(Double_t dr);
    Bool_t SetNewPosition();

    Double_t GetEnergy() const { return fEnergy; }

    Double_t GetZ() const      { return fZ; }
    Double_t GetPhi() const    { return fPhi; }
    Double_t GetR() const      { return fR; }

    Double_t GetTheta() const  { return fTheta; }
    Double_t GetPsi() const    { return fPsi; }

    ClassDef(MParticle, 1) // Container which holds hostograms for the Hillas parameters
};

#endif

