#include <iostream>
#include "TObjArray.h"

#include "rootfilehandler.h"
#include <stdlib.h>
using namespace std;

void
CreateRootFile(
        TString         loc_fname,
        int             verbosityLevel
        )
{
    TFile output_rootfile(loc_fname,"UPDATE");

    if (output_rootfile.IsZombie())
    {
        cout << "Error opening file" << endl;
        exit(-1);
    }
    else {
        if (verbosityLevel > 1) cout << "creating root-file...successfull" << endl;
        output_rootfile.pwd();
        output_rootfile.Close();
    }
}
//end of CreateRootFile
//----------------------------------------------------------------------------


TFile*
OpenRootFile(
        TString    loc_fname,
        int             verbosityLevel
        )
{
    TFile* output_rootfile = new TFile(loc_fname,"UPDATE");
    if (output_rootfile->IsZombie())
    {
        cout << "Error opening file" << endl;
        exit(-1);
    }
    else
    {
        if (verbosityLevel > 1)
        {
            cout << "...opening root-file:"
                 << loc_fname
                 << " successfull" << endl;
        }
    }
    return output_rootfile;
}
//end of OpenRootFile
//----------------------------------------------------------------------------


void
CloseRootFile(
        TFile*          output_rootfile
        )
{
    if (output_rootfile->IsZombie())
    {
    cout << "Error closing file" << endl;
    exit(-1);
    } else {
    output_rootfile->Close();
    }
    delete output_rootfile;
}
//end of CloseRootFile
//----------------------------------------------------------------------------


void
SaveHistograms(
        TString         loc_fname,
        TString         subdirectory,
        TObjArray*      histList,
        bool            saveResults,
        int             verbosityLevel
        )
{
    if (!saveResults) return;
    if (verbosityLevel > 2) cout << endl
                                 << "...saving pixel histograms to subdirectory: "
                                 << subdirectory << endl ;

    TFile* output_rootfile = NULL;
    output_rootfile = OpenRootFile( loc_fname, verbosityLevel);

    if (verbosityLevel > 2) cout << endl
                                 << "...writing histogram list to root file "
                                 << endl ;
    gFile->WriteTObject(histList, subdirectory); // write the histograms into one Key in the top level directory


    if (verbosityLevel > 3) output_rootfile->ls();
    CloseRootFile( output_rootfile ); // close the file
    if (verbosityLevel > 2) cout << "...done" << endl;
}
// end of SaveHistograms
//----------------------------------------------------------------------------


TString
CreateSubDirName(
        int pixel
        )
{
    TString path = "Pixel_";
    path += pixel;
//    cout << "path " << path << endl ;
    return path;
}
// end of CreateSubDirName
//----------------------------------------------------------------------------


TString
CreateSubDirName(
        TString title
        )
{
    title += "_Pixel";
//    cout << "path " << path << endl ;
    return title;
}
// end of CreateSubDirName
//----------------------------------------------------------------------------

