#!/usr/bin/python -tti

# script, which saves a lot of information about 
# DRS spikes in a file, for further analysis.
from pyfact import RawData
from drs_spikes import DRSSpikes
import numpy as np

# I need a callback function for the call of DRSSpikes
# this function should be a member of RawData, 
# so that it knows all necessary information
# In order to do this, I should inherit from RawData
# and just add one single function.
class RD_spike_ana( RawData ):
    def callback(self, drsspikes ):
        print 'Event ID', self.event_id
        print 'singles:'
        for s in drsspikes.singles:
            print np.unravel_index( s, (drsspikes.row, drsspikes.col) )

def spike_callback(drsspikes):
    print drsspikes.__dict__


data_file_name = '/home/dominik/20120223_205.fits.gz'
calib_file_name = '/home/dominik/20120223_202.drs.fits.gz'
outfile = None

run = RD_spike_ana( data_file_name, calib_file_name, return_dict=True)
despike = DRSSpikes(user_action = run.callback)




for event in run:
    data  = event['acal_data'][:,12:-12] 
    ddata = despike(data)

    ret = raw_input('q for quit')
    if 'q' in ret:
        break