#!/usr/bin/python -tti

# script, which saves a lot of information about 
# DRS spikes in a file, for further analysis.
from pyfact import RawData
from drs_spikes import DRSSpikes
import numpy as np
from plotters import Plotter
import scipy.signal as signal
# I need a callback function for the call of DRSSpikes
# this function should be a member of RawData, 
# so that it knows all necessary information
# In order to do this, I should inherit from RawData
# and just add one single function.
data_file_name = '/home/dominik/20120223_205.fits.gz'
calib_file_name = '/home/dominik/20120223_202.drs.fits.gz'
outfile = None

run = RawData( data_file_name, calib_file_name, return_dict=True)
despike = DRSSpikes()

single_pattern = np.array( (-1,2,-1) )
double_pattern = np.array( (-1,1,1,-1) )

bins = None

histplot = Plotter('hist')
cplot = Plotter('corr')
for event in run:
    print event['event_id']
    data  = event['acal_data'][:,12:-12]
    
    for pixel,sig in enumerate(data):
        corr = signal.correlate( sig, single_pattern, 'same')
        #cplot.name = corr+'_'+str(event['event_id']+'_'+str(pixel)
        cplot(corr)
        hist = np.histogram( corr, bins=1000, range=(0,2000) )
        if bins == None:
            bins = hist[0]
        else:
            bins += hist[0]
            
    histplot(bins)
