#!/usr/bin/python
#
# Werner Lustermann
# ETH Zurich
#
from ROOT import TH1F
import pyfact

from hist import histogramList

class bslHistograms( histogramList ):

    def book( self ):

        # print 'bslHistograms::book'
        
        self.h1d( "histo_mean","Value of maximal probability",
                  400, -99.5, 100.5, 'max value (mV)', 'Entries / 0.5 mV')

        self.h1d("hplt_mean","Value of maximal probability",
            1440, -0.5, 1439.5, 'max value in mV', 'Entries / 0.5 mV')
    
        self.h1d("histo_rms","RMS in mV",
                 2000, -99.5, 100.5, 'RMS (mV)', 'Entries / 0.5 mV' )

        self.h1d( 'hplt_rms', 'Value of maximal probability',
                   1440, -0.5, 1439.5, 'pixel', 'RMS in mV' )				   

def H1d( name, title, Nbin, first, last, xtitle, ytitle ):

    h = TH1F( name, title, Nbin, first, last );
    h.GetXaxis().SetTitle( xtitle );
    h.GetYaxis().SetTitle( ytitle );

    return h


def BookBslSummaryHistos( list ):

    list.add( 'hbsl_mean', H1d( "histo_mean","Value of maximal probability",
                               400, -99.5, 100.5,
                               'max value (mV)', 'Entries / 0.5 mV') )

    h = H1d("hplt_mean","Value of maximal probability",
            1440, -0.5, 1439.5, 'max value in mV', 'Entries / 0.5 mV')
    list.add( 'hplt_mean', h )

    h = H1d("histo_rms","RMS in mV",2000,-99.5,100.5, 'RMS (mV)', 'Entries / 0.5 mV' )
    list.add( 'hbsl_rms', h )

    list.add( 'hplt_rms',
              H1d( 'hplt_rms', 'Value of maximal probability',
                   1440,-0.5,1439.5, 'pixel', 'RMS in mV' ) )
				   
class tcalHistograms( histogramList ):

	def book( self ):
			
		self.h1d("diff_dev", "Differential Deviation", 1024, 0, 1024, 
		          "Bin in DRS4 pipeline", "Deviation per bin in ns")
		
		self.h1d("int_dev", "Integral Deviation", 1024, 0, 1024, 
		          "Bin in DRS4 pipeline", "Total Deviation in ns")
			  
		self.h1d("start", "distribution of startcells", 1024, 0, 1024,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("numxing", "number of crossings", 200, 0, 200,
		          "number of crossings", "counts")
			  
		self.h1d("lomeanxing", "Distribution of logic Meancrossing", 1024, 0, 1024,
		          "Cell of Meancrossing", "counts")
			  
		self.h1d("meanxing", "Distribution of physical Meancrossing", 1024, 0, 1024,
		          "Cell of Meancrossing", "counts")
			  
		self.h1d("corr", "Distribution of positive Corrections", 1024, 0, 1024,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("loleftout", "Distribution of left out Crossings", 1024, 0, 1024,
			  "Bin in DRS4 pipeline", "counts")
		  
		self.h1d("leftout", "Distribution of left out Crossings", 1024, 0, 1024,
		 	  "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("period", "Distribution of Period lenght", 10, 0, 10,
			  "number of cells within Period", "counts")
			  
		self.h1d("freq", "calculated Frequency of the Testwave", 100, 200, 300,
			  "Frequenz", "counts")
			  
			  
class tcalsimHistograms( histogramList ):

	def book( self ):
	
		self.h1d("diff_dev", "Differential Deviation", 1024, 0., 1024., 
		          "Bin in DRS4 pipeline", "Deviation per bin in ns")
		
		self.h1d("int_dev", "Integral Deviation", 1024, 0., 1024., 
		          "Bin in DRS4 pipeline", "Total Deviation in ns")
			  
		self.h1d("start", "distribution of startcells", 1024, 0., 1024.,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("numxing", "number of crossings", 200, 0, 200,
		          "number of crossings", "counts")
			  
		self.h1d("lomeanxing", "Distribution of logic Meancrossing", 1024, 0, 1024,
		          "Cell of Meancrossing", "counts")
			  
		self.h1d("meanxing", "Distribution of physical Meancrossing", 1024, 0, 1024,
		          "Cell of Meancrossing", "counts")
			  
		self.h1d("loleftout", "Distribution of left out Crossings", 1024, 0, 1024,
			  "Bin in DRS4 pipeline", "counts")
		  
		self.h1d("leftout", "Distribution of left our Crossings", 1024, 0, 1024,
		 	  "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("period", "Distribution of Period lenght", 1000, 2.5, 5.5,
			  "leght of Period", "counts")
			  
		self.h1d("data", "simulated Data", 1024, 0, 1024,
			  "Bin in DRS4 pipeline", "Data")
			  
		self.h1d("freq", "calculated Frequency of the Testwave", 100, 200, 300,
			  "Frequenz", "counts")
			  
		self.h1d("meanfreq", "mean calculated Frequency of the Testwave", 100, 200, 300,
			  "Frequenz", "counts")
			  
		self.h1d("conv", "Convergence of the Deviation", 200, 0, 200,
			  "Event", "Deviation from the true value")
			  
		self.h1d("perioddev", "Mean deviation from nominal Period for each Iteration", 1000, 0, 1000,
			  "number of iterations", "mean deviation")
			  
		self.h1d("perioddevproj", "Distribution of mean nominal Periods for each Iteration", 1000, -0.2, 0.2,
			  "Deviation of Period", "Counts")
			  
class tcalanaHistograms( histogramList ):

	def book( self ):
			  
		self.h1d("int_dev", "Integral Deviation", 1024, 0, 1024,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("diff_dev", "Differential Deviation", 1024, 0, 1024,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("diff_dev_true", "True Differential Deviation", 1024, 0, 1024,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("int_dev_true", "True Integral Deviation", 1024, 0, 1024,
		          "Bin in DRS4 pipeline", "counts")
			  
		self.h1d("data", "simulierte Daten", 1024, 0, 1024,
			  "Bin in DRS4 pipeline", "Data")
			  
		self.h1d("start", "distribution of startcells", 1024, 0., 1024.,
		          "Bin in DRS4 pipeline", "counts")
			  
			  
class periodHistograms( histogramList ):

	def book ( self ):
	
		self.h1d("periods", "Lenght of Periods", 2000, 0, 10,
			   "Period in ns", "counts")
			   
		self.h1d("diff", "PeriodOliver - PeriodRemo", 100, -0.3, 0.3,
			   "difference in ns", "counts")
			   
class amplitudesHistograms( histogramList ):

	def book ( self ):
			
		self.h1d("std", "Standard deviation", 20, 0, 20,
			   "Standardabweichung in mV", "count")
			   

class jitterHistograms( histogramList ):

	def book ( self ):
	
		self.h1d("diff", "Jitter Calculation", 500, 200, 230,
			   "difference between pulses in ns", "bin content")
			   
			   
		self.h1d("data0", "Data", 1024, 0, 1024,
			  "Bin in DRS4 pipeline", "Data")
			  
		self.h1d("data8", "Data", 1024, 0, 1024,
			  "Bin in DRS4 pipeline", "Data")
			  
class ftcalappHistograms( histogramList ):
	
	def book ( self ):
	
		self.h1d("avperiods", "distribution of periods for average data", 1000, 2, 6,
			   "period in ns", "bin content")
			   
		self.h1d("avperiods0", "distribution of periods at beginning for average data", 400, 2, 6,
			   "period in ns", "bin content")
			   
		self.h1d("periods", "distribution of periods", 400, 2, 6,
			   "period in ns", "bin content")
			   
		self.h1d("periods0", "distribution of periods at beginning", 400, 2, 6,
			   "period in ns", "bin content")
			   
		self.h1d("perioddev", "Mean deviation from nominal Period for each Iteration", 1000, 0, 1000,
			  "number of iterations", "mean deviation")
			  
		self.h1d("perioddevproj", "Distribution of mean nominal Periods for each Iteration", 1000, -0.2, 0.2,
			  "Deviation of Period", "Counts")
			   
		self.h1d("int_dev", "integral deviation", 1024, 0., 1024., 
		          "bin in DRS4 pipeline", "total deviation in ns")
		
	

              

