#ifndef TEMPLATEEXTRACTORS_H
#define TEMPLATEEXTRACTORS_H

#include <TROOT.h>
#include <TMath.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TString.h>

#include "pixel.h"

void
CalcMaxPropabilityOfSlice(
        TH2*            inputHisto,
        TH1*            outputHisto,
        int             verbosityLevel
        );

void
PlotMaxPropabilityPulse(
        Pixel*          CurrentPixel,
        int             verbosityLevel
        );

void
FitMaxPropabilityPulse(
        TH1F*           inputHisto,
        int             verbosityLevel
        );

Double_t MedianOfH1 (
        TH1*            inputHisto
        );

void
CalcMedianOfSlice(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

bool
WritePixelTemplateToCsv(
        Pixel*          CurrentPixel,
        TString         path,
        TString         overlayMethod,
        int             order,
        int             verbosityLevel
        );

#endif // TEMPLATEEXTRACTORS_H

