#include "pixelsum.h" // class implemented
using namespace std;

/////////////////////////////// PUBLIC ///////////////////////////////////////

//============================= LIFECYCLE ====================================


PixelSum::PixelSum(
        TString     pixelname,
        int         pixelID,
        int         maxPulsorder,
        int         verbosityLevel,
        bool        stats,
        TFile*      filename
        )
    :Pixel(
          pixelID,
          maxPulsorder,
          verbosityLevel,
          stats,
          filename
          )
{
    mName                   = pixelname;

    mhMaxByChid             = new TH2F*[mMaxPulseOrder];
    mhMeanByChid            = new TH2F*[mMaxPulseOrder];
    mhMedianByChid          = new TH2F*[mMaxPulseOrder];

    mhDistAmplitude         = new TH1F*[mMaxPulseOrder];
    mhDistSlopeRiseEdge     = new TH1F*[mMaxPulseOrder];
    mhDistSlopeFallEdge     = new TH1F*[mMaxPulseOrder];
}

PixelSum::~PixelSum()
{
    if (mVerbosityLevel > 1) cout << endl << "...delete histograms of pixelSum " << mChid ;

    DeleteHistos();
    DeleteDistributionHistos();

}// ~PixelSum


//============================= OPERATORS ====================================

//XX&
//XX::operator=(const XX&);
//{
//    return *this;

//}// =

//============================= OPERATIONS ===================================

//============================= ACESS      ===================================
//============================= INQUIRY    ===================================
/////////////////////////////// PROTECTED  ///////////////////////////////////

/////////////////////////////// PRIVATE    ///////////////////////////////////
void
PixelSum::BookHistos()
{
    if (mVerbosityLevel > 2) cout << endl << "...book pixel histograms" << endl;
    for (int order = 0; order < mMaxPulseOrder; order++)
    {
        //mhMaxByChid
        //----------------------------------------
        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("mhMaxByChid", order) << endl;
        mhMaxByChid[order]=new TH2F();

        MakeTH2Pretty(
                mhMaxByChid[order],
                "mhMaxByChid",
                "Distribution of Templates extracted with Max"
                );

        hList->Add( mhMaxByChid[order] );
        //----------------------------------------

        //mhMeanByChid
        //----------------------------------------
        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("mhMeanByChid", order) << endl;
        mhMeanByChid[order]=new TH2F();

        MakeTH2Pretty(
                mhMeanByChid[order],
                "mhMeanByChid",
                "Distribution of Templates extracted with Mean",
                    order
                );

        hList->Add( mhMeanByChid[order] );
        //----------------------------------------

        //mhMedianByChid
        //----------------------------------------
        if (mVerbosityLevel > 3) cout << "\t...booking " << HistoName("mhMedianByChid", order) << endl;
        mhMedianByChid[order]=new TH2F();

        MakeTH2Pretty(
                mhMedianByChid[order],
                "mhMedianByChid,
                "Distribution of Templates extracted with Median",
                    order
                );

        hList->Add( mhMedianByChid[order] );
        //----------------------------------------
    }
    if (mVerbosityLevel > 2) cout << "...done" << endl;
}
// end of BookHistos
//----------------------------------------------------------------------------

void
PixelSum::BookDistributionHistos()
{
    if (mVerbosityLevel > 2) cout << endl
                                  << "...book pixelsum distibution histograms" << endl;
    for (int order = 0; order < mMaxPulseOrder; order++)
    {
        //mhDistAmplitude
        //----------------------------------------
        if (mVerbosityLevel > 3) cout << "\t...booking "
                                      << HistoName("mhDistAmplitude", order) << endl;
        mhDistAmplitude[order]=new TH2F();

        MakeTH1Pretty(
                mhDistAmplitude[order],
                "mhDistAmplitude",
                "Distribution of Templates extracted with Max",
                    order
                );

        hList->Add( mhDistAmplitude[order] );
        //----------------------------------------

        //mhDistSlopeRiseEdge
        //----------------------------------------
        if (mVerbosityLevel > 3) cout << "\t...booking "
                                      << HistoName("mhDistSlopeRiseEdge", order) << endl;
        mhDistSlopeRiseEdge[order]=new TH2F();

        MakeTH1Pretty(
                mhDistSlopeRiseEdge[order],
                "mhDistSlopeRiseEdge",
                "Distribution of Templates extracted with Max",
                    order
                );

        hList->Add( mhDistSlopeRiseEdge[order] );
        //----------------------------------------

        //mhDistSlopeFallEdge
        //----------------------------------------
        if (mVerbosityLevel > 3) cout << "\t...booking "
                                      << HistoName("mhDistSlopeFallEdge", order) << endl;
        mhDistSlopeFallEdge[order]=new TH2F();

        MakeTH1Pretty(
                mhDistSlopeFallEdge[order],
                "mhDistSlopeFallEdge",
                "Distribution of Templates extracted with Max",
                    order
                );

        hList->Add( mhDistSlopeFallEdge[order] );
        //----------------------------------------

    }
    if (mVerbosityLevel > 2) cout << "...done" << endl;
}
// end of BookDistributionHistos
//----------------------------------------------------------------------------

void
PixelSum::DeleteHistos()
{
    if (mVerbosityLevel > 2)
    {
        cout << endl
             << "\t...delete current overlay histograms of Pixel# " << mChid;
    }
    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mVerbosityLevel > 3)
        cout << endl << "\t\t...deleting mhMaxByChid"
                                      << mChid << "_" << order;

        delete mhMaxByChid[order];
        mhMaxByChid[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting mhMeanByChid"
                                      << mChid << "_" << order ;
        delete mhMeanByChid[order];
        mhMeanByChid[order] = NULL;

        if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting mhMedianByChid"
                                      << mChid << "_" << order ;
        delete mhMedianByChid[order];
        mhMedianByChid[order] = NULL;
    }
    if (mVerbosityLevel > 3) cout << endl << "\t...deleting histogram Arrays";

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting mhMaxByChid";
    delete[] mhMaxByChid;
    mhMaxByChid = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting mhMeanByChid";
    delete[] mhMeanByChid;
    mhMeanByChid = NULL;

    if (mVerbosityLevel > 3) cout << endl << "\t\t...deleting mhMedianByChid";
    delete[] mhMedianByChid;
    mhMedianByChid = NULL;
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------

void
PixelSum::DeleteDistributionHistos()
{
    if (mVerbosityLevel > 2)
    {
        cout << endl
             << "\t...delete current distribution histograms" ;
    }

    for (int order = 0;
         order < mMaxPulseOrder;
         order ++)
    {
        if (mOptions.Contains("S"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting mhDistAmplitude"
                                          << mChid << "_" << order ;
            delete mhDistAmplitude[order];
        }

        if (mOptions.Contains("R"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting mhDistSlopeRiseEdge"
                                          << mChid << "_" << order ;
            delete mhDistSlopeRiseEdge[order];
        }

        if (mOptions.Contains("M"))
        {
            if (mVerbosityLevel > 3) cout << endl
                                          << "\t\t...deleting mhDistSlopeFallEdge"
                                          << mChid << "_" << order ;

            delete mhDistSlopeFallEdge[order];
        }

    }

    if (mVerbosityLevel > 3) cout << endl << "\t...deleting histogram Arrays";

    if (mOptions.Contains("S"))
    {
        if (mVerbosityLevel > 3)
            cout << endl << "\t\t...deleting mhDistAmplitude";
        delete[] mhDistAmplitude;
        mhDistAmplitude = NULL;
    }

    if (mOptions.Contains("R"))
    {
        if (mVerbosityLevel > 3)
            cout << endl << "\t\t...deleting mhDistSlopeRiseEdge";
        delete[] mhDistSlopeRiseEdge;
        mhDistSlopeRiseEdge = NULL;
    }

    if (mOptions.Contains("M"))
    {
        if (mVerbosityLevel > 3)
            cout << endl << "\t\t...deleting mhDistSlopeFallEdge";
        delete[] mhDistSlopeFallEdge;
        mhDistSlopeFallEdge = NULL;
    }
}
// end of DeletePixelHistos
//----------------------------------------------------------------------------
