/**  a sum of attributes and histograms of several pixels.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see pixel.h
 */

#ifndef PIXELSUM_H
#define PIXELSUM_H

// SYSTEM INCLUDES

#include <iostream>
using namespace std;
//

// PROJECT INCLUDES
#include "pixel.h"
//

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//

class PixelSum : public Pixel
{
public:
// LIFECYCLE

    /** Default constructor.
    */

//    /** Copy constructor.
//    *
//    * @param from The value to copy to this object.
//    */
    PixelSum(
            TString     pixelname,
            int         pixelID,
            int         maxPulsorder,
            int         verbosityLevel,
            bool        stats,
            TFile*      filename,
            int         pixelOverlayXaxisLeft,
            int         pixelOverlayXaxisRight,
            float       bSLMean,
            float       gainMean,
            TString     options
            );

/** Destructor.
*/
~PixelSum();

// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS

    //Histogram Booking
    void
    BookSumHistos();

    void
    BookSumDistributionHistos();

    void
    DeleteSumHistos();

    void
    DeleteSumDistributionHistos();
// ACCESS
// INQUIRY
    TString             mName;

    //Pixel Histos
    TH2F**              mhMaxByChid;
    TH2F**              mhMeanByChid;
    TH2F**              mhMedianByChid;

    //Distribution Histos
    TH1F**              mhDistAmplitude;
    TH1F**              mhDistSlopeRiseEdge;
    TH1F**              mhDistSlopeFallEdge;





};

// INLINE METHODS
//

// EXTERNAL REFERENCES
//

#endif // PIXELSUM_H
