//////////////////////////////////////////////////////////////
//Functions for FPulsetemplate to write template Pulse to csv
//////////////////////////////////////////////////////////////

#include "SaveToCsv.h"
#include <TROOT.h>
#include <TH1F.h>
#include <TString.h>

TString
BuildPath(
        TString         path,
        TString     csv_file_name,
        int             pixel
        )
{
    path += csv_file_name;
    path += "_";

    if (pixel = -1)
        path += "AllPixel";
    else
        path += pixel;
    path += ".csv";

    return path;
}


void
WritePixelTemplateToCsv(
        TH1*            phInputHistogram,
        TString         path,
        TString     csv_file_name,
        TString     overlay_method,
        int             pixel,
        int             verbosityLevel
        )
{
    path = BuildPath(path, csv_file_name, pixel); //if want to write ALL pixel= -1

    Int_t nbins = phInputHistogram->GetXaxis()->GetNbins();

    if (verbosityLevel > 0)
    {
        cout << "writing point-set to csv file: " ;
        cout << path << endl;
        cout << "...opening file" << endl;
    }
    if (verbosityLevel > 2) cout << "...number of bins " << nbins << endl;

    ofstream out;
    out.open( path );

    out << "### point-set of a single photon pulse template" << endl
        << "### template determined with pulse overlay at: "
        << overlay_method;
    if ( pixel = -1 )
        out << "of all Pixels";
    else
        out << endl;
    out << "### Slice's Amplitude determined by calculating the " << endl
        << "### value of maximum propability of slice -> Amplitude1 " << endl
        << "### mean of slice -> Amplitude2 " << endl
        << "### median of slice -> Amplitude3 " << endl
        << "### for each slice" << endl
        << "### Pixel number (CHid): " << pixel << endl
        << endl
        << "time [slices],Amplitude1 [mV],Amplitude2 [mV],Amplitude3 [mV]" << endl;

    for (int TimeSlice=1;TimeSlice<=nbins;TimeSlice++)
    {
        out << TimeSlice
            << "," << phInputHistogram->GetBinContent(TimeSlice);
//            << "," << hPixelMean[0]->GetBinContent(TimeSlice);
//            << "," << hPixelMedian[0]->GetBinContent(TimeSlice) << endl;
    }

    out.close();
    if (verbosityLevel > 0) cout << "...file closed" << endl;
}

