<?PHP

require_once("config.php");

function login()
{
    global $ldaphost;
    global $baseDN;
    global $groupDN;

    $username = $_SERVER['PHP_AUTH_USER'];
    $password = $_SERVER['PHP_AUTH_PW'];

    $con = @ldap_connect($ldaphost);
    if (!$con)
        return "ldap_connect failed to ".$ldaphost;

    //------------------ Look for user common name
    $attributes = array('cn', 'mail');
    $dn         = 'ou=People,'.$baseDN;
    $filter     = '(uid='.$username.')';

    $sr = @ldap_search($con, $dn, $filter, $attributes);
    if (!$sr)
        return "ldap_search failed for dn=".$dn.": ".ldap_error($con);

    $srData = @ldap_get_entries($con, $sr);
    if ($srData["count"]==0)
        return "No results returned by ldap_get_entries for dn=".$dn.".";

    $email         =$srData[0]['mail'][0];
    $userCommonName=$srData[0]['cn'][0];
    $userDN        =$srData[0]['dn'];

    //------------------ Authenticate user
    if (!@ldap_bind($con, $userDN, $password))
        return "ldap_bind failed: ".ldap_error($con);

    //------------------ Check if the user is in FACT ldap group
    $attributes= array("member");
    $filter= '(objectClass=*)';

    // Get all members of the group.
    $sr = @ldap_read($con, $groupDN, $filter, $attributes);
    if (!$sr)
        return "ldap_read failed for dn=".$groupDN.": ".ldap_error($con);

    // retrieve the corresponding data
    $srData = @ldap_get_entries($con, $sr);
    if ($srData["count"]==0)
        return "No results returned by ldap_get_entries for dn=".$dn.".";

    @ldap_unbind($con);

    $found = false;
    foreach ($srData[0]['member'] as $member)
        if (strpos($member, "cn=".$userCommonName.",")===0)
            return "";

    return "Sorry, your credentials don't match!";
}
// --------------------------------------------------------------------

if (isset($_GET['logout']))
{
    if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']))
        return;

    return header('HTTP/1.0 401 Successfull logout!');
}

// --------------------------------------------------------------------

if (!isset($_GET['start']) && !isset($_GET['stop']))
    return header('HTTP/1.0 400 Command not supported');

// --------------------------------------------------------------------
/*
if (!isset($_SERVER['PHP_AUTH_USER']) || !isset($_SERVER['PHP_AUTH_PW']))
{
    header('WWW-Authenticate: Basic realm="SmartFACT++"');
    header('HTTP/1.0 401 Unauthorized');
    return;
}

$rc = login();
if ($rc!="")
    return header('HTTP/1.0 401 '.$rc);
*/
// --------------------------------------------------------------------

$out = array();

if (isset($_GET['stop']))
    $str = exec($path."/dimctrl --stop", $out, $rc);

if (isset($_GET['start']))
{
    $args = '\"'.$_GET['start'].'\"';

    unset($_GET['start']);

    /*
     $args = "";
     foreach ($_GET as $key => $value)
        $args .= " --arg:".$key."=".$value;
     $str = exec($path."/dimctrl --exec ".$args, $out, $rc);
     */

    if (isset($_GET['label']))
    {
        $args .= ":".$_GET['label'];
        unset($_GET['label']);
    }

    foreach ($_GET as $key => $value)
        $args .= ' \"'.$key.'='.$value.'\"';

    $str = exec($path.'/dimctrl --start "'.$args.'"', $out, $rc);
}

if ($rc!=1 && $rc!=2)
    return header('HTTP/1.0 500 Execution failed [rc='.$rc."]");

print($rc);

if (isset($_GET['debug']))
{
    print("\n");
    print_r($out);
}

?>
