#include <QtGui>

#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>
#include <qwt_scale_engine.h>
#include <qwt_analog_clock.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>

#include <limits.h>
#include <float.h>

#include "dic.hxx"
#include "Evidence.h"

#define NO_LINK "__&DIM&NOLINK&__" // for checking if DIMserver is alive

// General indicator for DIM service
class FCS_Indicator: public QLineEdit, public DimClient, public DimBrowser {
    Q_OBJECT

    char *ServiceName;
    DimStampedInfo *Data;

    QPoint dragStart;
	
    void infoHandler();
    void mousePressEvent(QMouseEvent *); 
    void mouseReleaseEvent(QMouseEvent *); 
    void mouseMoveEvent(QMouseEvent *); 
	
  public:
    FCS_Indicator(char*, QWidget* = NULL);
    ~FCS_Indicator();

  signals:
    void YEP(QString);
};

// Graph class for history display
class FCS_Plot: public QwtPlot, public DimClient {
    Q_OBJECT

    char *Name;
    DimInfo *Data;
    void infoHandler();

    QMenu *Menu;
    QAction *YLogAction;
    QAction *NormAction;
    
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;
    QwtPlotCurve *Signal;
    QwtPlotZoomer *Zoomer;

    void dragEnterEvent(QDragEnterEvent *);
    void dropEvent(QDropEvent *);

  public:
    FCS_Plot(char*, QWidget* = NULL);
    ~FCS_Plot();

  private slots:    
    void HandleZoom(const QwtDoubleRect &);
    void contextMenuEvent(QContextMenuEvent *);    
    void MenuYScale();
    void MenuZoomOut();
    void MenuSave();
    void MenuPrint();

 signals:
     void YEP();

};

// Main window class
class GUI: public QMainWindow {
    Q_OBJECT

    FCS_Indicator *Value, *Value1;
    FCS_Plot *Graph, *Graph1;
    QwtAnalogClock *Clock;
	
    QWidget *Central, *MainWidget, *BiasWidget;
    QGridLayout *MainLayout, *BiasLayout;

    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *); 
         
  public:
    GUI();
    ~GUI();
};
