#ifndef TEMPLATEEXTRACTORS_H
#define TEMPLATEEXTRACTORS_H

#include <TROOT.h>
#include <TMath.h>
#include <TProfile.h>
#include <TH2F.h>
#include <TH1I.h>
#include <TH1F.h>
#include <TString.h>
#include <TSystem.h>

#include "pixel.h"

/** Assignment operator.
* @todo do me
* @warning not implemented
* @param from THe value to assign to this object.
*
* @return A reference to this object.
*/

/** CalcMaxPropabilityOfSlice(
        TH2*            inputHisto,
        TH1*            outputHisto,
        int             verbosityLevel
        );
* Generates a Y-Projection for each slice of a TH2 histogram
* Then calls the Value of the bin with Maximum Value and puts it
* into the corresponding bin of a TH1 histogram
* @see Event::CalibrateAllPixel()
* @see Event::CalculatePhotonCharge()
*/
void
CalcMaxPropabilityOfSlice(
        TH2*            inputHisto,
        TH1*            outputHisto,
        int             verbosityLevel
        );

void
PlotMaxPropabilityPulse(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

void
FitMaxPropabilityPulse(
        TH1F*           inputHisto,
        int             verbosityLevel
        );

Double_t MedianOfH1 (
        TH1*            inputHisto
        );

void
PlotMedianOfSlice(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

void
PlotMeanOfSlice(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             verbosityLevel
        );

void
ExtractPulseTemplate(
        Pixel*          CurrentPixel,
        TString         overlayType,
        int             order,
        int             verbosityLevel
        );

bool
WritePixelTemplateToCsv(
        Pixel*          CurrentPixel,
        TString         path,
        TString         overlayMethod,
        int             order,
        int             verbosityLevel
        );

#endif // TEMPLATEEXTRACTORS_H

