/********************** FPulseTemplate ***********************
* open a root-file with pulse overlay histograms
* calculate most propable Pulse-Shape
* compute pulse height and pulse integral spektrum of the peaks
+ draw histos for single, double, tripple, ....above 100mV Photonpulses
+ draw Parameterdevelopment depending on photon quantity
+ form a template (shape depending on number of photons)
  so it can be used for detection of other peaks
*************************************************************/

//----------------------------------------------------------------------------
// root libraries
//----------------------------------------------------------------------------

#include <TROOT.h>
#include <TCanvas.h>
#include <TTimer.h>
#include <Getline.h>
#include <TMath.h>
#include <TFile.h>
#include <TStyle.h>
#include <TString.h>

#include <stdio.h>
#include <stdint.h>
#include <cstdio>
#include <iostream>
#include <fstream>
using namespace std;

#define NPIX  1440
#define NCELL 1024
#define FAD_MAX_SAMPLES 1024
#define MAX_PULS_ORDER 1
#define HAVE_ZLIB

//----------------------------------------------------------------------------
// rootmacros
//----------------------------------------------------------------------------
#include "rootfilehandler.h"
#include "pixel.h"
#include "pixelsum.h"
#include "templateextractors.h"

//----------------------------------------------------------------------------
// Decleration of global variables
//----------------------------------------------------------------------------
bool breakout=false;

//----------------------------------------------------------------------------
// Initialisation of Root Objects
//----------------------------------------------------------------------------

// Temporary Objects

//Pixelwise Histograms

//All Pixel Histograms

//Root-File Objects
TObjArray*  hAllPixelList       = NULL;
TObjArray*  hRootList           = NULL;

//Canvases
TCanvas**   cgpPixelPulses      = NULL;
TCanvas**   cgpAllPixelPulses   = NULL;
TCanvas**   cgpDistributions    = NULL;
//TCanvas*    cgpTestHistos       = NULL;

//----------------------------------------------------------------------------
// Functions
//----------------------------------------------------------------------------
void DeletePixelCanvases( int, int );
void
UpdateCanvases(
        int verbosityLevel,
        int max_pulse_order,
        bool testmode
        );
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// MAIN - Funtion
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
int FCalcPulseTemplate(
    TString     InRootFileName        = "20120309_018.root",
    TString     InputPath           = "analysis/FPulseTemplate/20120309_018/Overlay/",
    TString     OutputRootFileName     = "test.root",
    TString     OutPutPath          = "analysis/FPulseTemplate/20120309_018/",
    bool        ProduceGraphic      = true,
//    bool        fitdata             = false,
    bool        stats               = false,
    bool        debugPixel          = false,
    int         pixelSetSize        = 40,
    int         maxPulseOrder       = 3,
//    int         refresh_rate        = 500,      //refresh rate for canvases
    int         verbosityLevel      = 5,        // different verbosity levels can be implemented here
    int         firstpixel          = 0,
    int         npixel              = 2
        )
{

    InputPath       = SetHostsPaths(true, InputPath );
    OutPutPath      = SetHostsPaths(true, OutPutPath );

//----------------------------------------------------------------------------
//	Open-Root-File Settings
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...load root file" << endl;
    }

    TFile * inputRootFile
            = OpenRootFile( InputPath, InRootFileName, verbosityLevel );

    TFile * outputRootFile
            = OpenRootFile( OutPutPath, OutputRootFileName, verbosityLevel );
//----------------------------------------------------------------------------
//	Define operation range
//----------------------------------------------------------------------------
    if ( npixel == -1 )
    {
        npixel = NPIX - firstpixel;
    }


    if ( pixelSetSize == -1 )
    {
        pixelSetSize = firstpixel +npixel;
    }

//    float GainMean  = GainMean;  // this has to be extracted from root files
//    float BSLMean   = BSLMean;    // this has to be extracted from root files

//----------------------------------------------------------------------------
//	root global Settings
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...setting up root environment" ;
    }

    gStyle->SetPalette(1,0);
    gROOT->SetStyle("Plain");
//    gPad->SetGrid();



//----------------------------------------------------------------------------
//	root Canvas Settings
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...preparing canvases" << endl;
    }

    //Canvas Pad numbering
    int PixelCanvasFrameNrs[4]      = {
        1,  // Top left
        2,  // Top right
        3,  // bottom left
        4   // bootom right
    };

    //Canvas Pad numbering
    int AllpixelCanvasFrameNrs[4]   = {
        1,  // Top left
        2,  // Top right
        3,  // bottom left
        4   // bootom right
    };

    if (ProduceGraphic)
    {

        //Canvases
        cgpPixelPulses              = new TCanvas*[maxPulseOrder];
        cgpDistributions            = new TCanvas*[maxPulseOrder];

        //TCanvas*    gpcDevelopment = NULL;
        TString cName               = "";
        TString cTitle              = "";

        //naming of pulse canvases
        for (
             int pulse_order = maxPulseOrder - 1;
             pulse_order >= 0 ;
             pulse_order--
              )
        {
            cName   ="cgpDistributions";
            cName  += pulse_order;

            cTitle  ="Distributions of Pulses with Order of: ";
            cTitle += pulse_order;

            cgpDistributions[pulse_order]
                    = new TCanvas(cName,cTitle, 720,pulse_order*20,720,720);
            cgpDistributions[pulse_order]->Divide(2, 2);

            cName   ="cgpPixelPulses";
            cName  += pulse_order;

            cTitle  ="Overlays of Pulses with Order of: ";
            cTitle  += pulse_order;

            cgpPixelPulses[pulse_order]
                     = new TCanvas(cName,cTitle, 0,pulse_order*20,720,720);
            cgpPixelPulses[pulse_order]->Divide(2, 2);
        }
    }

//-----------------------------------------------------------------------------
// Filter-Settings
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// prepare datafile
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Initialize Pixels
//----------------------------------------------------------------------------
    if (verbosityLevel > 0)
    {
        cout << endl << "...preparing pixels" << endl;
    }

    Pixel**     pixel       = new Pixel*[NPIX];

    for (int i = 0 ; i < NPIX; i++)
    {
        pixel[i] = NULL;
    }

    PixelSum*   wholeCamera = NULL;

    bool        first_pass  = true;

//-------------------------------------
// Loop over Pixel Sets
//-------------------------------------
    for ( int firstPixelOfSet = firstpixel;
          firstPixelOfSet < firstpixel + npixel;
          firstPixelOfSet += pixelSetSize )
    {
        if (verbosityLevel >= 0)
        {
            cout << "------------------------------------------------"
                 << endl
                 << "...processing Pixel: "
                 << firstPixelOfSet
                 << " to Pixel: "
                 << firstPixelOfSet+pixelSetSize-1
                 << endl;
        }

        //--------------------------------------------------------------------
        // Loops over every Pixel of a Set of Pixels
        //--------------------------------------------------------------------
        for ( int pixelID = firstPixelOfSet;
              pixelID < firstPixelOfSet + pixelSetSize
              && pixelID < firstpixel + npixel;
              pixelID++ )
        {

            if (verbosityLevel > 1)
            {
                cout << "-------------------------------------"
                     << endl
                     << "...processing Set from Pixel "
                     << firstPixelOfSet
                     << " to Pixel "
                     << firstPixelOfSet+pixelSetSize-1
                     << " Pixel: " << pixelID
                     << "/" << firstpixel + npixel -1
                     << endl;
            }

            //-------------------------------------
            // Create individual Pixel
            //-------------------------------------
            if (verbosityLevel > 3)
            {
                cout << "...creating pixel: " << pixelID << endl;
            }

           pixel[pixelID] = new Pixel(
                       pixelID,
                       maxPulseOrder,  ///One should get this from the file
                       verbosityLevel,
                       stats,
                       "L",
                       70,   ///TODO: get it from the root file
                       230,  ///TODO: get it from the root file
                       -1,   ///TODO: get it from the root file
                       9,    ///TODO: get it from the root file
                       inputRootFile
                    );

            if (breakout)   break;

            //Preparing Camera
            if (first_pass)
            {
                if (verbosityLevel > 0)
                {
                    cout << endl << "...preparing camera" << endl;
                }

                wholeCamera = new PixelSum(
                            "AllPixel",
                            1440,
                            maxPulseOrder,
                            verbosityLevel,
                            stats,
                            "",
                            pixel[pixelID]->mPixelOverlayXaxisLeft,
                            pixel[pixelID]->mPixelOverlayXaxisRight ,
                            pixel[pixelID]->mBSLMean ,
                            pixel[pixelID]->mGainMean ,
                            outputRootFile
                            );

                first_pass = false;
            }
            //-------------------------------------
            // Histogramms of Maximas in Overlay Spectra
            //-------------------------------------

            for ( int pulse_order = 0 ;
                  pulse_order < pixel[pixelID]->mMaxPulseOrder ;
                  pulse_order ++)
            {
                if (verbosityLevel > 2)
                {
                    cout << "-------------------------------------"
                         << endl
                         << "...processing Set from Pixel "
                         << firstPixelOfSet
                         << " to Pixel "
                         << firstPixelOfSet+pixelSetSize-1
                         << " Pixel: " << pixelID
                         << "/" << firstpixel + npixel -1
                         << " Pulse-Order: " << pulse_order
                         << endl;
                }

                // Calculate Max Prop. Value of each slice
                //-------------------------------------

                //from Maximum Overlay
                if (verbosityLevel > 2)
                {
                    cout << "...extracting templates from Maximum Overlay "
                         << endl;
                }

                ExtractPulseTemplate(
                            pixel[pixelID],
                            "Maximum",
                            pulse_order,
                            verbosityLevel
                            );

                //from Edge Overlay
                if (verbosityLevel > 2)
                {
                    cout << "...extracting templates from Edge Overlay "
                         << endl;
                }
                ExtractPulseTemplate(
                            pixel[pixelID],
                            "Edge",
                            pulse_order,
                            verbosityLevel
                            );

                WritePixelTemplateToCsv(
                            pixel[pixelID],
                            OutPutPath,
                            "Maximum",
                            pulse_order,
                            verbosityLevel
                            );

                WritePixelTemplateToCsv(
                            pixel[pixelID],
                            OutPutPath,
                            "Edge",
                            pulse_order,
                            verbosityLevel
                            );

                if (ProduceGraphic)
                {
                    pixel[pixelID]->DrawTemplateHistograms(
                                cgpPixelPulses,
                                PixelCanvasFrameNrs
                                );

                    pixel[pixelID]->DrawEdgeTemplateHistograms(
                                cgpPixelPulses,
                                PixelCanvasFrameNrs
                                );
                }
                //-------------------------------------
                // Fill Histogramms of Camera
                //-------------------------------------

                wholeCamera->hMaxOverlay[pulse_order]->Add(
                            pixel[pixelID]->hMaxOverlay[pulse_order]
                            );

                wholeCamera->hMaxProfile[pulse_order]->Add(
                            pixel[pixelID]->hMaxProfile[pulse_order]
                            );

                wholeCamera->hEdgeOverlay[pulse_order]->Add(
                            pixel[pixelID]->hEdgeOverlay[pulse_order]
                            );

                wholeCamera->hEdgeProfile[pulse_order]->Add(
                            pixel[pixelID]->hEdgeProfile[pulse_order]
                            );


                if (verbosityLevel > 2)
                {
                cout << endl
                     << "...End of pulseorder "
                     << pulse_order
                     << endl;
                }

            }
            // End of Loop over pulsorder of current Pixel

            if (ProduceGraphic)
            {
                UpdateCanvases(
                            verbosityLevel,
                            MAX_PULS_ORDER,
                            false
                            );
            }

            if (debugPixel)
            {
                //Process gui events asynchronously during input
                cout << endl;
                TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
                timer.TurnOn();
                TString input = Getline("Type 'q' to exit, <return> to go on: ");
                timer.TurnOff();
                if (input=="q\n")
                {
                       break;
                }
            }



            //deleteCurrent Pixel from Heap
            delete  pixel[pixelID];
            pixel[pixelID]  = NULL;

            if (verbosityLevel > 2)
            {
            cout << endl
                 << "...End of Pixel"
                 << endl
                 << "------------------------------------------------"
                 << endl;
            }
        }
        // End of Loop over all Pixels of set

        if (verbosityLevel > 1)
        {
        cout << endl
             << "...End of Loop over all Pixels of set"
             << endl
             << "------------------------------------------------"
             << endl;
        }
    }
    // End of Loop over all Pixelsets

    if (verbosityLevel > 0)
    {
    cout << endl
         << "...End of Loop over all Pixelsets"
         << endl
         << "------------------------------------------------"
         << endl;
    }

    delete[] pixel;
    pixel = NULL;

//-------------------------------------
// Draw All Pixel Histograms
//-------------------------------------

    for ( int pulse_order = 0 ;
          pulse_order < wholeCamera->mMaxPulseOrder ;
          pulse_order ++)
    {
        if (verbosityLevel > 2)
        {
            cout << "-------------------------------------"
                 << endl
                 << "...processing Pulse-Order: "
                 << pulse_order;
        }

// Calculate Max Prop. Value of each slice
//-------------------------------------

        //from Maximum Overlay
        ExtractPulseTemplate(
                    wholeCamera,
                    "Maximum",
                    pulse_order,
                    verbosityLevel
                    );
        WritePixelTemplateToCsv(
                    wholeCamera,
                    OutPutPath,
                    "Maximum",
                    pulse_order,
                    verbosityLevel
                    );

        //from Edge Overlay
        ExtractPulseTemplate(
                    wholeCamera,
                    "Edge",
                    pulse_order,
                    verbosityLevel
                    );
        WritePixelTemplateToCsv(
                    wholeCamera,
                    OutPutPath,
                    "Edge",
                    pulse_order,
                    verbosityLevel
                    );

//        wholeCamera->DrawTemplateHistograms(
//                    cgpPixelPulses,
//                    PixelCanvasFrameNrs
//                    );

//        wholeCamera->DrawEdgeTemplateHistograms(
//                    cgpPixelPulses,
//                    PixelCanvasFrameNrs
//                    );
    } //EOF: Draw All Pixel Histograms


//-------------------------------------
// Save All Pixel Histograms
//-------------------------------------

//    SaveHistograms(     //save histograms of all pixel into output root file
//                OutInRootFileName,
//                CreateSubDirName("All"),
//                hAllPixelList,
//                verbosityLevel
//                );

//    SaveHistograms(     //save histograms of generell results into output root file
//                OutInRootFileName,
//                "root",
//                hRootList,
//                verbosityLevel
//                );

//    if (ProduceGraphic)
//    {
//        UpdateCanvases(
//                    verbosityLevel,
//                    MAX_PULS_ORDER,
//                    false
//                    );
//    }

//-------------------------------------
// Delete Objects on Heap
//-------------------------------------
    delete wholeCamera;
    if (ProduceGraphic)
    {
        DeletePixelCanvases( maxPulseOrder ,verbosityLevel );
    }
    delete inputRootFile;
    delete outputRootFile;

    return( 0 );
}
//----------------------------------------------------------------------------
// end of main function
//-----------------------------------------------------------------------------




//-----------------------------------------------------------------------------
// Funktions
//-----------------------------------------------------------------------------
void
DeletePixelCanvases(
        int         maxPulseOrder,
        int         verbosityLevel
        )
{
    if (verbosityLevel > 2)
    {
        cout << endl
             << "...delete pixel Canvases"
             << endl;
    }

    for ( int pulse_order = 0; pulse_order < maxPulseOrder; pulse_order++ )
    {
        delete cgpPixelPulses[pulse_order];
        cgpPixelPulses[pulse_order]     = NULL;

        delete cgpDistributions[pulse_order];
        cgpDistributions[pulse_order]   = NULL;
    }

    delete[] cgpPixelPulses;
    cgpPixelPulses      = NULL;

    delete[] cgpDistributions;
    cgpDistributions    = NULL;
}

void
UpdateCanvases(
        int         verbosityLevel,
        int         max_pulse_order,
        bool        testmode
        )
{
    if (verbosityLevel > 3)
    {
        cout << endl << "...updating canvases" << endl;
    }
    for (int pulse_order = 0; pulse_order < max_pulse_order; pulse_order++)
    {
        cgpPixelPulses[pulse_order]->Modified();
        cgpPixelPulses[pulse_order]->Update();

        cgpDistributions[pulse_order]->Modified();
        cgpDistributions[pulse_order]->Update();
//        if ( testmode )
//        {
//            cgpTestHistos->Modified();
//            cgpTestHistos->Update();
//        }
    }
}
//-----------------------------------------------------------------------------
// MAIN Funktion for C compilation
//-----------------------------------------------------------------------------

int main()
{
    FCalcPulseTemplate();
    return 0;
}
