#!/usr/bin/python -tti
from fpydim import *



def IsReadyForDataTaking( verbose = True ):
    drive = drive_control
    bias = bias_control
    fad = fad_control
    
    msg = MSG()
    msg.output = verbose
    msg("Checking if System isready for data taking... ")

    ok = True
    if not drive() == 7:
        msg.warn( drive.state()[0] + "  NOT ok")
        ok = False
    if not feedback() == 12:
        msg.warn( feedback.state()[0] + "  NOT ok")
        ok = False
    if not bias() == 9:
        msg.warn( bias.state()[0] + "  NOT ok")
        ok = False
    if not fad() == 4:
        msg.warn( fad.state()[0] + "  NOT ok")
        ok = False
    
    if ok:
        msg.ok( " all ok " )

    return ok

def StopTracking( verbose = True ):
    msg = MSG()
    msg.output = verbose

    # defining a shortcut 
    drive = drive_control

    drive.stop()
    if not drive.wait(5, 10):
        msg.warn("drive did not reach state 5 after 10 seconds")
        msg.warn( drive.state()[0].rstrip('\x00') )
        return False

    return True

def TakeDataRun( verbose = True ):
    fad = fad_control    
    msg = MSG()
    msg.output = verbose
    if not IsReadyForDataTaking( verbose=False ):
        msg.fail("System not Ready for DataTaking")
        IsReadyForDataTaking( verbose=True )
        return False
    mcp.start(300,-1,'data\0')
    if not fad.wait(8, 10):
        msg.warn("FAD not in Writing Data after 10seconds")
        return False
    msg("... taking data: 300 seconds - normal data run")
    if not fad.wait(4, 330):
        msg.warn("FAD did not return to Connected, after 330 seconds")
        return False
    return True

def TrackSource( Shift=0.6, Angle=50, SrcName='Crab', verbose=True):
    drive = drive_control
    
    msg = MSG()
    msg.output = verbose

    if not drive.wait(5, 10):
        msg.warn("drive not ready after 10sec")
        msg.warn( drive.state()[0].rstrip('\x00') )
        return False

    SrcName += '\0'
    drive.track_source( Shift, Angle, SrcName)
    
    return True

def WaitForTracking( CalmDownTime = 30, verbose = True):
    drive = drive_control

    msg = MSG()
    msg.output = verbose

    if not drive.wait(6, 10):
        msg.warn("drive not in state moving after 10sec")
        return False

    if not drive.wait(7, 10):
        msg.warn("drive not in state Tracking after 10sec")
        return False

    msg("waiting "+str(CalmDownTime)\
            +"sec for drive to calm down and tracking to be stable")
    time.sleep(CalmDownTime)
    return True

def PrepareBias( verbose = True):
    msg = MSG()
    msg.output = verbose
    bias = bias_control

    if feedback() != 12:
        msg.warn("feedback is not in Current Control")
        return False

    bias.set_global_dac(1)
    if not bias.wait(9, 10):
        msg.warn("bias not in Voltage ON after 10sec")
        return False
    if not bias.wait(5, 10):
        msg.warn("bias not Ramping after 10sec")
        return False
    if not bias.wait(9, 30):
        msg.warn("bias not fully ramped up after 30sec")
        return False

    msg("waiting 45sec...")    
    time.sleep(45)
    return True

def TakePedestalOnRun( verbose = True ):
    msg = MSG()
    msg.output = verbose
    if not IsReadyForDataTaking( verbose=False ):
        msg.fail("System not Ready for DataTaking")
        IsReadyForDataTaking( verbose=True )
        return False
    mcp.start(-1,1000,'pedestal\0')
    if not fad.wait(8, 10):
        msg.warn("FAD not in Writing Data after 10seconds")
        return False
    msg("... taking ped: 1000evts @25Hz")
    if not fad.wait(4, 50):
        msg.warn("FAD did not return to Connected, after 50 seconds")
        return False
    return True
    
def TakeExtLpRun( verbose = True ):
    msg = MSG()
    msg.output = verbose
    if not IsReadyForDataTaking( verbose=False ):
        msg.fail("System not Ready for DataTaking")
        IsReadyForDataTaking( verbose=True )
        return False
    mcp.start(-1,1000,'light-pulser-ext\0')
    if not fad.wait(8, 10):
        msg.warn("FAD not in Writing Data after 10seconds")
        return False
    msg("... taking light-pulser-ext: 1000evts @25Hz")
    if not fad.wait(4, 50):
        msg.warn("FAD did not return to Connected, after 50 seconds")
        return False
    return True

def TakeData( verbose = True):
    msg = MSG()
    msg.output = verbose
    TakePedestalOnRun()
    TakeExtLpRun()
    for i in range(4):
        i +=1
        msg("Taking Data Run "+str(i)+" of 4")
        TakeDataRun()

def Take( time=0, events=0, runtype='drs-pedestal', verbose=True):
    msg = MSG()
    msg.output = verbose
    fad = fad_control
    runtype += '\0'
    if not fad.wait(4, 10):
        msg.warn("fad not connected after 10sec")
        return False
    mcp.start( time, events, runtype)
    if not fad.wait(8, 30):
        msg.warn("fad not Writing Data after 30sec")
        return False
    timeout = float('inf')
    if time != -1:
        timeout = time*1.1
    if not fad.wait(4, timeout):
        msg.warn("Data Writing not finished after "+str(timeout)+"sec")
        return False
    return True

def TakeDrsCalibration( verbose = True):
    msg = MSG()
    msg.output = verbose
    bias = bias_control
    fad = fad_control

    bias.set_zero_voltage()
    if not bias.wait(7, 10):
        msg.warn("bias has not switched of after 10sec")
        return False
    fad.start_drs_calibration()
    Take( -1, 1000, 'drs-pedestal')
    Take( -1, 1000, 'drs-gain')
    Take( -1, 1000, 'drs-pedestal')
    fad.set_file_format(2)
    Take( -1, 1000, 'drs-pedestal')
    Take( -1, 1000, 'drs-time')
    Take( -1, 1000, 'drs-time-upshifted')
    fad.reset_secondary_drs_baseline()
    Take(-1, 1000, 'pedestal')
    fad.set_file_format(2)
    Take(-1, 1000, 'pedestal')

def BlinkenLights(verbose = True):
    msg = MSG(verbose)
    fad = fad_control

    for i in range(10):
        fad.set_file_format(2)
        time.sleep(1)
        fad.set_file_format(0)
        time.sleep(1)

def TakeAmplCalib( roi=1024, verbose=True):
    msg = MSG(verbose)
    bias = bias_control
    fad  = fad_control
    if (roi!=1024) and (roi!=300):
        raise ValueError('roi must be 300 or 1024')
    # I do not understand, why the out put needs to be ENABLED??
    feedback.enable_output(0)
    bias.set_zero_voltage()
    bias.wait(7) # VoltageOff
    fad.start_drs_calibration
    
    Take(-1, 1000, 'drs-pedestal')
    Take(-1, 1000, 'drs-gain')
    if roi == 300:
        Take(-1, 1000, 'pedestal')
    if roi == 1024:
        Take(-1, 1000, 'drs-pedestal')

    fad.set_file_format(2)
    if roi == 300:
        Take(-1, 1000, 'pedestal')
    if roi == 1024:
        Take(-1, 1000, 'drs-pedestal')

def TakeTimeCalib( verbose=True ):
    msg = MSG( verbose )
    feedback.enable_output(0)
    if bias() != 7:
        bias.set_zero_voltage()
        if not bias.wait(7, 10):
            msg.warn("bias not ramped down after 10sec")
            return False
    fad.set_file_format(2)
    Take(-1, 1000, 'drs-time')
    Take(-1, 1000, 'drs-time-upshifted')


# create introduction:
class INTRO(object):
    def __init__(self):
        # nothing to do
        pass
        
    def __repr__(self):
        print "welcome to PyDimCtrl V0.1:"
        print "--------------------------"
        print "If the hardware is ON but not all the software is connected try:"
        print "      Connect()"
        print "If all the programs are already up and running, you might want to"
        print "     TakeDrsAmplitudeCalibration(roi=1024) or "
        print "     TakeDrsAmplitudeCalibration(roi=300)"
        print "         i.e. ped, gain, trigger_offset + extra ped(for X-check)"
        print "     TakeDrsTimeCalibration( type='upshifted' ) or "
        print "     TakeDrsTimeCalibration( type='old' ) or "
        print "     "
        print "In case you would like to ramp up the Bias voltage try:"
        print "     VoltageOn( mode='temperature' ) or"
        print "     VoltageOn( mode='current' ) or"
        print "     VoltageOn( mode='light_pulser' )"
        print "Switch off with:"
        print "     VoltageOff()"
        print ""
        print "In case you would like a Watchdog to check, if the Voltage is up"
        print "and the BiasCrate is not disconnected, then try:"
        print "     VoltageOn( mode='--see above--', Watchdog=True )"
        print "PLEASE NOTE: The Watchdog will monitor the State of BIAS_CONTROL"
        print "and in case of a connection loss, it will: "
        print "     * print a warning"
        print "     * issue a the RECONNECT command" 
        print "     * issue SET_ZERO_VOLTAGE - since this is the only way to get referenced"
        print "     * Ramp up again, using the same settings as before"
        print "     * possible OverCurrent situation will be treated as usual"
        print "The Watchdog will not react on any other state change, like OverCurrent or VoltageOff"
        print ""
        print ""
        return ""
        

intro = INTRO()

if __name__ == '__main__':
    print "welcome:"
    print " type: intro"
    print " for a short introduction"

    
    #IsReadyForDataTaking()
    #TrackSource( Shift=0.6, Angle=50, SrcName='Crab', verbose=True)
    #WaitForTracking( CalmDownTime = 30, verbose = True)
    #TakeDataRun()
    #StopTracking()
