#!/usr/bin/python -itt

##############################################
# by Q. Weitzel and T. Kraehenbuehl
#
# plot rates and DTs for all runs of one night
# in addition, plot DT outliers
#
# adapt base_path to select the night
# (and change title and zoom of the graph)
##############################################

from array import array
import os
import re
import numpy as np

from pyfact import SlowData
from plotters import CamPlotter

from ROOT import TCanvas, TPad, TGraph
from ROOT import gROOT
from ROOT import gStyle

gROOT.SetStyle("Plain")

base_path = "/fact/aux/2012/05/20/"

filelist = []

for base,subdirs,files in os.walk(base_path):
    for filename in files:
        #include only run files
        regex = re.search(r'_\d\d\d\.FTM_CONTROL_TRIGGER_RATES',filename)
        #include run files and also the nightly file
        #regex = re.search(r'FTM_CONTROL_TRIGGER_RATES',filename)
        if regex:
            filelist.append(os.path.join(base,filename))

filelist2 = []

for base,subdirs,files in os.walk(base_path):
    for filename in files:
        regex = re.search(r'_\d\d\d\.FTM_CONTROL_STATIC_DATA',filename)
        if regex:
            filelist2.append(os.path.join(base,filename))

trigger_rate_array = array("d",[])
time_array = array("d",[])

for filename in filelist:

    print filename

    file_handle = SlowData(filename)

    file_handle.register("TriggerRate")
    file_handle.register("Time")
    file_handle.register("FTMtimeStamp")

    ftm_ts_old = 1E10

    for row in file_handle:
        if row.FTMtimeStamp>ftm_ts_old:#needed to remove negative rate in first report
            trigger_rate_array.append(float(row.TriggerRate))
            time_array.append(float(row.Time)*24*3600)
        ftm_ts_old = row.FTMtimeStamp

dt_min_array = array("d", [])
dt_max_array = array("d", [])
dt_avg_array = array("d", [])
time_array2 = array("d", [])

#trick to get the same x-axis range for all graphs
time_array2.append(min(time_array))
dt_min_array.append(float(-1))
dt_max_array.append(float(-1))
dt_avg_array.append(float(-1))

mycamplotter = CamPlotter('Outlier Search Plot',  map_file_path = '../map_dn.txt', vmin=0, vmax=10)
pixel_outlier_array = np.zeros(1440) 
patch_outlier_array = np.zeros(160)

for filename in filelist2:

    print filename

    file_handle = SlowData(filename)

    file_handle.register("PatchThresh")
    file_handle.register("Time")
    file_handle.register("FTMtimeStamp")

    ftm_ts_old = 1E10

    tmp_outliers = np.zeros(160)

    for row in file_handle:
        if row.FTMtimeStamp>ftm_ts_old:#just do the same cut as for the rates
            time_array2.append(float(row.Time)*24*3600)
            dt_min_array.append(float(min(row.PatchThresh)))
            dt_max_array.append(float(max(row.PatchThresh)))
            dt_avg_array.append(float(sum(row.PatchThresh))/len(row.PatchThresh))
            tmp_outliers = row.PatchThresh > dt_avg_array[-1] + 15
        ftm_ts_old = row.FTMtimeStamp

    patch_outlier_array += tmp_outliers

for i,value in enumerate(patch_outlier_array):
    for j in range(9):
        pixel_outlier_array[i*9 + j] = value

#trick to get the same x-axis range for all graphs
time_array2.append(max(time_array))
dt_min_array.append(float(-1))
dt_max_array.append(float(-1))
dt_avg_array.append(float(-1))

canv = TCanvas("canv","canv",600,50,1000,600)
pad1 = TPad("pad1","",0,0,1,1)
pad2 = TPad("pad2","",0,0,1,1)
pad3 = TPad("pad3","",0,0,1,1)
pad4 = TPad("pad4","",0,0,1,1)
pad2.SetFillStyle(4000);#will be transparent
pad2.SetFrameFillStyle(0);
pad3.SetFillStyle(4000);#will be transparent
pad3.SetFrameFillStyle(0);
pad4.SetFillStyle(4000);#will be transparent
pad4.SetFrameFillStyle(0);

graph = TGraph(len(trigger_rate_array),time_array,trigger_rate_array)
graph2 = TGraph(len(dt_min_array),time_array2,dt_min_array)
graph3 = TGraph(len(dt_max_array),time_array2,dt_max_array)
graph4 = TGraph(len(dt_avg_array),time_array2,dt_avg_array)

#change the time format to human readable
graph.GetXaxis().SetTimeDisplay(1);
graph2.GetXaxis().SetTimeDisplay(1);
graph3.GetXaxis().SetTimeDisplay(1);
graph4.GetXaxis().SetTimeDisplay(1);
graph.GetXaxis().SetTimeFormat("%H:%M%F1970-01-01 00:00:00")
graph2.GetXaxis().SetTimeFormat("%H:%M%F1970-01-01 00:00:00")
graph3.GetXaxis().SetTimeFormat("%H:%M%F1970-01-01 00:00:00")
graph4.GetXaxis().SetTimeFormat("%H:%M%F1970-01-01 00:00:00")

#define markers, titles, etc.
graph.SetMarkerStyle(7)
graph2.SetMarkerStyle(7)
graph3.SetMarkerStyle(7)
graph4.SetMarkerStyle(7)
graph.SetMarkerSize(1)
graph2.SetMarkerSize(1)
graph3.SetMarkerSize(1)
graph4.SetMarkerSize(1)
graph.SetMarkerColor(2)
graph2.SetMarkerColor(3)
graph3.SetMarkerColor(6)
graph4.SetMarkerColor(4)
graph.SetTitle("Night 20.05.2012")
graph2.SetTitle("")
graph3.SetTitle("")
graph4.SetTitle("")
graph.GetYaxis().SetRangeUser(0,250)#zoom to be adapted for each night
graph2.GetYaxis().SetRangeUser(150,495)#zoom to be adapted for each night
graph3.GetYaxis().SetRangeUser(150,495)#zoom to be adapted for each night
graph4.GetYaxis().SetRangeUser(150,495)#zoom to be adapted for each night
graph.GetXaxis().SetTitleOffset(1.2)
graph2.GetXaxis().SetTitleOffset(1.2)
graph3.GetXaxis().SetTitleOffset(1.2)
graph4.GetXaxis().SetTitleOffset(1.2)
graph.GetXaxis().SetTitle("UTC+4h  (hh:mm)")#for summer time
graph2.GetXaxis().SetTitle("")#for summer time
graph3.GetXaxis().SetTitle("")#for summer time
graph4.GetXaxis().SetTitle("")#for summer time
graph.GetYaxis().SetTitle("Trigger Rate (Hz)")
graph2.GetYaxis().SetTitle("Patch Threshold (DAC Counts)")
graph3.GetYaxis().SetTitle("")
graph4.GetYaxis().SetTitle("")

pad1.Draw();
pad1.cd();
graph.Draw("ap");

pad2.Draw();
pad2.cd();
graph2.Draw("apY+");

pad3.Draw();
pad3.cd();
graph3.Draw("apY+");

pad4.Draw();
pad4.cd();
graph4.Draw("apY+");

mycamplotter(pixel_outlier_array)
