#ifndef MARS_MCamDisplay
#define MARS_MCamDisplay

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif
#ifndef ROOT_TClonesArray
#include <TClonesArray.h>
#endif

class TBox;
class TText;
class TVirtualPad;

class MGeomCam;
class MHexagon;
class MCerPhotEvt;
class MCerPhotPix;

class MCamDisplay : public TObject
{
private:
    MGeomCam      *fGeomCam;     // pointer to camera geometry

    Bool_t         fAutoScale;   // indicating the autoscale function

    UInt_t         fNumPixels;   // number of pixels in the present geometry
    Float_t        fRange;       // the range in millimeters of the present geometry

    Float_t        fMinPhe;      // The minimal number of Phe
    Float_t        fMaxPhe;      // The maximum number of Phe

    TClonesArray  *fPixels;      // array of all hexagons
    TClonesArray  *fLegend;      // array of all color bars
    TClonesArray  *fLegText;     // array of all texts

    UInt_t         fW;           // Width of canvas
    UInt_t         fH;           // Height of canvas
    TVirtualPad   *fDrawingPad;  // pad in which we are drawing
    Bool_t         fIsAllocated;

    TBox  *GetBox(Int_t i)  { return (TBox*) fLegend->At(i); }
    TText *GetText(Int_t i) { return (TText*)fLegText->At(i); }

    MHexagon &operator[](int i) { return *((MHexagon*)fPixels->At(i)); }

    void  SetPixColor(const MCerPhotPix &pix, const Int_t i);
    Int_t GetColor(Float_t wert);

    void UpdateLegend();
    void Paint(Option_t *option="");

public:
    MCamDisplay(MGeomCam *geom);
    ~MCamDisplay();

    void SetAutoScale(Bool_t input=kTRUE) { fAutoScale = input; }
    void DrawPhotNum(const MCerPhotEvt *event);

    void DrawPixelNumbers();

    void Reset();
    void Draw(Option_t *option="");
    void SavePrimitive(ofstream &out, Option_t *);

    ClassDef(MCamDisplay, 0) // Displays the magic camera
};

#endif
