#include "configfile.h"
using namespace std;

/////////////////////////////// PUBLIC ///////////////////////////////////////

//============================= LIFECYCLE ====================================

configfile::configfile(
        TString      rcFileName,
        TString      processType
        )
{
    mRcFileName         = rcFileName;
    mProcessType        = processType;

    cout << "...opening RC File" << endl;
    DefineTokens();

    // reading rc-File:
    ifstream rcFile;
    rcFile.open(mRcFileName, ifstream::in);

    bool rcReadable = true;
    rcReadable = CheckIfRcReadable( rcFile );
    if ( !rcReadable )
    {
        cerr << "rc File is not readable" << endl;
        return;
    }
    SetParamFromRc( rcFile );
    rcFile.close();
    return;
}

//XX::XX(const XX&)
//{
//}// XX

configfile::~configfile()
{
}// ~XX


//============================= OPERATORS ====================================

//XX&
//XX::operator=(const XX&);
//{
//    return *this;

//}// =

//============================= OPERATIONS ===================================

// decode arguments
void
configfile::DefineTokens()
{
    mDataFileNameRC         = "DataFileName";
    mDrsFileNameRC          = "DrsFileName";
    mInputFileRC            = "InputFileName";
    mInputPathRC            = "InputPath";
    mOutputFileRC           = "OutputFileName";
    mOutputPathRC           = "OutPutPath";

    mFirstPixelRC           = "firstPixel";
    mNumPixelRC             = "nPixel";
    mPixelSetSizeRC         = "pixelSetSize";
    mFirstEventRC           = "firstEvent";
    mNumEventsRC            = "nEvents";
    mMaxOrderRC             = "maxPulseOrder";

    mGainMeanRC             = "gainMean";
    mBSLMeanRC              = "bslMean";

    mAmplWindowWidthRC      = "AmplWindowWidth";
    mAvg1RC                 = "sildingAvgWin1";
    mAvg2RC                 = "sildingAvgWin2";
    mOverlayWindowLeftRC    = "olWindowLeft";
    mOverlayWindowRightRC   = "olWindowRight";

    mHistoOptionsRC         = "histoOptions";
    mRefreshRateRC          = "refreshRate";
    mSpikeDebugRC           = "spikeDebug";
    mVerbLevelRC            = "verbosityLevel";
    mDbgPixelRC             = "debugPixel";
    mSaveRC                 = "saveResults";
    mProduceGraphicRC       = "produceGraphic";
    mFitDataRC              = "fitdata";
    mTestModeRC             = "testmode";
    mPrintStatsRC           = "stats";

    cout << "...defining tokens" << endl;
}

bool
configfile::CheckIfRcReadable( ifstream& rcFile )
{
    cout << "...checking if config file readable" << endl;
    if(!rcFile)
    {
        cerr << "***** no config-file in the user defined directory.\n"
             << "Check the path .\n" << endl;
        return false;
    }

    if(!rcFile.good()) {
        cerr << "***** not able to read config-file." << endl;
        return false;
    }
    return true;
}

void
configfile::SetParamFromRc( ifstream& rcFile )
{
    cout << "...reading RC File" << endl;

    int             index;
    char            input[256];
    char*     word;
    TString         keyword;

    const char*     comment             = "#";
    while (rcFile.good())
    {
        if(!rcFile.good())
        {
            cout << "no more lines to read" << endl;
            break;
        }

        rcFile.getline(input,256); // get one line of the file parameter.config
        word = strtok(input," \t");

        if(word != NULL)
        {
            keyword = word;

        }
        index = 0;
        while ( word != NULL)
        {
            // skip comment lines
            if ( *word == *comment)
            {
                break ;
            }
            else
            {
                CheckKeywords( keyword, word, index );
            }

            word = strtok(NULL, " "); // take next token or set word to NULL
            index++;
        }
    }

    PrintSetParameters();
}

void
configfile::CheckKeywords(
        TString         keyword,
        const char*     word,
        int             index
        )
{
    const char*     yes                 = "yes";
    const char*     no                  = "no";

    //------------------------------------------------------------------------
    // filenames and pathes
    //------------------------------------------------------------------------

    // get Input Data File Name
    if( keyword == mDataFileNameRC )
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mDataFileName       = word;
        }
    }

    // get Input DRS-Config File Name
    else if( keyword == mDrsFileNameRC )
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mDrsFileName        = word;
        }
    }

    // get Input Path
    else if( keyword == mInputPathRC )
    {
        if(index == 1)
        {
            mInputPath          = word;
        }
    }

    // get Input File
    else if(keyword == mInputFileRC)
    {
        if (mProcessType.Contains("verlay")) return;
        if(index == 1)
        {
            mInputFile          = word;
        }
    }

    // get Output Path
    else if(keyword == mOutputPathRC)
    {
        if(index == 1)
        {
            mOutputPath         = word;

        }

    }

    // get Output File
    else if(keyword == mOutputFileRC)
    {
        if(index == 1)
        {
            mOutputFile   = word;
        }
    }

    //------------------------------------------------------------------------
    // Parameters
    //------------------------------------------------------------------------

    // get number of first event
    else if(keyword == mFirstEventRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mFirstEvent         = atoi(word);

        }
    }

    // get number of events computed
    else if(keyword == mNumEventsRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mNumEvents         = atoi(word);

        }
    }

    // get number of first pixel
    else if(keyword == mFirstPixelRC)
    {
        if(index == 1)
        {
            mFirstPixel         = atoi(word);
        }
    }

    // get maximum number of pixels computed
    else if(keyword == mNumPixelRC)
    {
        if(index == 1)
        {
            mNumPixel           = atoi(word);

        }
    }

    // get size of a pixel set
    else if(keyword == mPixelSetSizeRC)
    {
        if(index == 1)
        {
            mPixelSetSize       = atoi(word);

        }
    }

    // get condition for maxeOrderRC graphic
    else if(keyword == mMaxOrderRC)
    {
        if(index == 1)
        {
            mMaxOrder           = atoi(word);

        }
    }

    // get parameter for mean of gain
    else if(keyword == mGainMeanRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mGainMean           = atof(word);

        }
    }

    // get parameter for mean of baseline
    else if(keyword == mBSLMeanRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mBSLMean            = atof(word);

        }
    }


    // get parameter for the windowwith of 1. Slidiging average filter
    else if(keyword == mAmplWindowWidthRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mAmplWindowWidth     = atoi(word);
        }
    }

    // get parameter for the windowwith of 1. Slidiging average filter
    else if(keyword == mAvg1RC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mAvg1               = atoi(word);

        }
    }

    // get parameter for the windowwith of 2. Slidiging average filter
    else if(keyword == mAvg2RC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mAvg2               = atoi(word);

        }
    }

    // get parameter for left edge of window in wich pulses are overlayed
    else if(keyword == mOverlayWindowLeftRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mOverlayWindowLeft  = atoi(word);

        }
    }

    // get parameter for right edge of window in wich pulses are overlayed
    else if(keyword == mOverlayWindowRightRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            mOverlayWindowRight  = atoi(word);

        }
    }

    //------------------------------------------------------------------------
    // Conditions
    //------------------------------------------------------------------------

    // get verbositylevel
    else if(keyword == mVerbLevelRC)
    {
        if(index == 1)
        {
            mVerbLevel          = atoi(word);
        }
    }

    // get Refreshrate of histograms
    else if(keyword == mRefreshRateRC)
    {
        if(index == 1)
        {
            mRefreshRate          = atoi(word);
        }
    }

    // get condition for produceing graphic
    else if(keyword == mProduceGraphicRC)
    {
        if(index == 1)
        {
            if (*word == *yes)
            {
                mProduceGraphic   = true;

            }
            if (*word == *no)
            {
                mProduceGraphic   = false;

            }
        }
    }

    // get condition for saving
    else if(keyword == mSaveRC)
    {
        if(index == 1)
        {
            if (*word == *yes)
            {
                mSave   = true;

            }
            if (*word == *no)
            {
                mSave   = false;

            }
        }
    }

    // get condition for mFitDataRC graphic
    else if(keyword == mFitDataRC)
    {
        if(index == 1)
        {
            if (*word == *yes)
            {
                mFitData   = true;

            }
            if (*word == *no)
            {
                mFitData   = false;

            }
        }
    }

    // get condition for mPrintStatsRC graphic
    else if(keyword == mPrintStatsRC)
    {
        if(index == 1)
        {
            if (*word == *yes)
            {
                mPrintStats         = true;

            }
            if (*word == *no)
            {
                mPrintStats         = false;

            }
        }
    }

    // get condition for showing single pixel graphics
    else if(keyword == mDbgPixelRC)
    {
        if(index == 1)
        {
            if (*word == *yes)
            {
                mDbgPixel           = true;

            }
            if (*word == *no)
            {
                mDbgPixel           = false;
            }
        }
    }

    // get condition for showing spike detection histograms
    else if(keyword == mSpikeDebugRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            if (*word == *yes)
            {
                mSpikeDebug         = true;

            }
            if (*word == *no)
            {
                mSpikeDebug         = false;

            }
        }
    }

    // get condition for showing spike detection histograms
    else if(keyword == mTestModeRC)
    {
        if (mProcessType.Contains("emplate")) return;
        if(index == 1)
        {
            if (*word == *yes)
            {
                mTestMode         = true;

            }
            if (*word == *no)
            {
                mTestMode         = false;

            }
        }
    }

    // get condition for showing single pixel graphics
    else if(keyword == mHistoOptionsRC)
    {
        if(index == 1)
        {
            mHistoOptions           = word;
        }
    }
return ;
}
//EOF: CheckKeywords

void
configfile::PrintSetParameters()
{
    //------------------------------------------------------------------------
    // filenames and pathes
    //------------------------------------------------------------------------
    if (mProcessType.Contains("verlay"))
    {
        cout << endl
             << "data file:\t\t\t"
             << mDataFileName << endl;

        cout << "drs config File:\t\t"
             << mDrsFileName << endl;
    }
    cout << endl
         << "input Path:\t\t\t"
         << mInputPath << endl;

    if (mProcessType.Contains("emplate"))
    {
        cout << "input data File:\t\t"
             << mInputFile << endl;
    }
    cout << "output folder:\t\t\t"
         << mOutputPath << endl;

    cout << "output data File:\t\t"
         << mOutputFile << endl;
    cout << endl;

    //------------------------------------------------------------------------
    // Parameters
    //------------------------------------------------------------------------

    cout << "First Pixel:\t\t\t"
         << mFirstPixel << endl;

    cout << "# of pixels:\t\t\t";
    if ( mNumPixel == -1 ) cout << "All" << endl;
    else cout << mNumPixel << endl;

    cout << "Size of Pixelset:\t\t";
    if ( mPixelSetSize == -1 ) cout << "Max" << endl;
    else cout << mPixelSetSize << endl;

    if (mProcessType.Contains("verlay"))
    {
        cout << "First Event:\t\t\t"
             << mFirstEvent << endl;

        cout << "# of Events:\t\t\t";
        if ( mNumEvents == -1 ) cout << "All" << endl;
        else cout << mNumEvents << endl;
        cout << endl;
    }

    cout << "Maximum Pulseorder:\t\t"
         << mMaxOrder << endl;
    if (mProcessType.Contains("verlay"))
    {
        cout << "Mean of Gain:\t\t\t"
             << mGainMean << endl;

        cout << "Mean of Baseline:\t\t"
             << mBSLMean << endl;

        cout << "Sliding Average 1:\t\t"
             << mAvg1 << endl;

        cout << "Sliding Average 2:\t\t"
             << mAvg2 << endl;

        cout << "Overlay Window's Left Edge:\t"
             << mOverlayWindowLeft << endl;

        cout << "Overlay Window's Right Edge:\t"
             << mOverlayWindowRight << endl;
    }
    //------------------------------------------------------------------------
    // Conditions
    //-----------------------------------------------------------------------

    cout << "Verbosity Level:\t\t"
         << mVerbLevel << endl;

    cout << "Histogram Options:\t\t"
         << mHistoOptions << endl;

    cout << "Refresh Rate:\t\t\t"
         << mRefreshRate
         << endl
         << endl;

    if (mProduceGraphic) cout << "will produce graphics" << endl;
    else cout << "will not produce graphics" << endl;

    if (mSave) cout << "will save" << endl;
    else cout << "will not save" << endl;

    if (mProcessType.Contains("emplate"))
    {
        if (mFitData) cout << "will fit" << endl;
        else cout << "will not fit" << endl;
    }

    if (mPrintStats) cout << "will print stats" << endl;
    else cout << "will not print stats" << endl;

    if (mDbgPixel) cout << "will show single pixel histos " << endl;
    else cout << "will not show single pixel histos " << endl;

    if (mProcessType.Contains("verlay"))
    {
        if (mSpikeDebug) cout << "will show pulse smothing histos " << endl;
        else cout << "will not show pulse smothing histos " << endl;

        if (mTestMode) cout << "will operate in testmode " << endl;
        else cout << "will not operate in testmode " << endl;
    }
}

//============================= ACESS      ===================================
//============================= INQUIRY    ===================================
/////////////////////////////// PROTECTED  ///////////////////////////////////

/////////////////////////////// PRIVATE    ///////////////////////////////////
