/**  A one line description of the class.
 *
 * #include "XX.h" <BR>
 * -llib
 *
 * A longer description.
 *
 * @see something
 */

#ifndef CONFIGFILE_H
#define CONFIGFILE_H

// SYSTEM INCLUDES
#include "TString.h"

#include <iostream>
#include <fstream>


//

// PROJECT INCLUDES
//

// LOCAL INCLUDES
//

// FORWARD REFERENCES
//


class configfile
{
public:
// LIFECYCLE

    /** Default constructor.
    */
    configfile( TString, TString );


//    /** Copy constructor.
//    *
//    * @param from The value to copy to this object.
//    */
//    XX(const XX& from);


    /** Destructor.
    */
    ~configfile();


// OPERATORS

//    /** Assignment operator.
//    *
//    * @param from THe value to assign to this object.
//    *
//    * @return A reference to this object.
//    */
//    XX&                     operator=(const XX& from);

// OPERATIONS

    void DefineTokens( );
    void CheckKeywords( TString, const char*, int );
    bool CheckIfRcReadable( std::ifstream& rcFile );
    void SetParamFromRc(    std::ifstream& rcFile );
    void PrintSetParameters();

// ACCESS
// INQUIRY

    TString         mRcFileName;

    TString         mDataFileName;
    TString         mDrsFileName;
    TString         mInputFile;
    TString         mInputPath;
    TString         mOutputFile;
    TString         mOutputPath;

    int             mFirstPixel;
    int             mNumPixel;
    int             mPixelSetSize;
    int             mFirstEvent;
    int             mNumEvents;
    int             mMaxOrder;

    float           mGainMean;
    float           mBSLMean;

    int             mAmplWindowWidth;
    int             mAvg1;
    int             mAvg2;
    int             mOverlayWindowLeft;
    int             mOverlayWindowRight;

    TString         mHistoOptions;
    int             mRefreshRate;
    int             mVerbLevel; // different verbosity levels can be implemented here
//    int             mCmdVerbLevel; // different verbosity levels can be implemented here
    bool            mDbgPixel;
    bool            mSave;
//    bool            mCmdSave;
    bool            mProduceGraphic;
//    bool            mCmdProduceGraphic;
    bool            mFitData;
    bool            mPrintStats;
    bool            mSpikeDebug;
    bool            mTestMode;

protected:

private:
    TString         mProcessType;
    const char*     mDataFileNameRC;
    const char*     mDrsFileNameRC;
    const char*     mInputFileRC;
    const char*     mInputPathRC;
    const char*     mOutputFileRC;
    const char*     mOutputPathRC;

    const char*     mFirstPixelRC;
    const char*     mNumPixelRC;
    const char*     mPixelSetSizeRC;
    const char*     mFirstEventRC;
    const char*     mNumEventsRC;
    const char*     mMaxOrderRC;

    const char*     mGainMeanRC;
    const char*     mBSLMeanRC;

    const char*     mAmplWindowWidthRC;
    const char*     mAvg1RC;
    const char*     mAvg2RC;
    const char*     mOverlayWindowLeftRC;
    const char*     mOverlayWindowRightRC;

    const char*     mHistoOptionsRC;
    const char*     mRefreshRateRC;
    const char*     mVerbLevelRC;
    const char*     mDbgPixelRC;
    const char*     mSaveRC;
    const char*     mProduceGraphicRC;
    const char*     mFitDataRC;
    const char*     mPrintStatsRC;
    const char*     mSpikeDebugRC;
    const char*     mTestModeRC;
};

// INLINE METHODS
//

// EXTERNAL REFERENCES
//

#endif // CONFIGFILE_H
