#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include <QtGui>
 
#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>
#include <qwt_scale_engine.h>
#include <qwt_analog_clock.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>
#include <qwt_legend.h>
#include <qwt_legend_item.h>

#include <limits.h>
#include <float.h>

#include "dic.hxx"
#include "Evidence.h"

#define NO_LINK "__&DIM&NOLINK&__" // for checking if DIMserver is alive
#define SVN_REVISION "$Revision: 138 $"
		  
// General indicator for DIM service
class Edd_Indicator: public QLineEdit, public DimClient, public DimBrowser {
    Q_OBJECT

    char *ServiceName;
    DimStampedInfo *Data;

    QPoint dragStart;
	
    void infoHandler();
    void mousePressEvent(QMouseEvent *); 
    void mouseReleaseEvent(QMouseEvent *); 
    void mouseMoveEvent(QMouseEvent *); 
	
  public:
    Edd_Indicator(char*, QWidget* = NULL);
    ~Edd_Indicator();

  signals:
    void YEP(QString);
};

// Graph class for history display
class Edd_Plot: public QwtPlot, public DimClient {
    Q_OBJECT

    struct PlotItem {
      DimInfo *Data;
      QwtPlotCurve *Signal;
      double *x;
      double *y;
      int Count;
      double Smallest;
      double Largest;
    };

    QList<struct PlotItem> Items;
    QMutex Mutex;
    
    QMenu *Menu;
    QAction *YLogAction;
    QAction *NormAction;
    
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;
    QwtPlotZoomer *Zoomer;
    QwtLegend *Legend;
    
    void AddService(char *);
    void infoHandler();    
    void dragEnterEvent(QDragEnterEvent *);
    void dropEvent(QDropEvent *);

  public:
    Edd_Plot(char *, QWidget * = NULL);
    ~Edd_Plot();

  private slots:
    void UpdatePlot();
    void HandleZoom(const QwtDoubleRect &);
    void contextMenuEvent(QContextMenuEvent *);    
    void MenuZoomOut();
    void MenuSingleTrace();        
    void MenuSave();
    void MenuPrint();

 signals:
     void YEP();

};

// Main window class
class GUI: public QMainWindow {
    Q_OBJECT

    Edd_Indicator *Value, *Value1;
    Edd_Plot *Graph, *Graph1;
    QwtAnalogClock *Clock;
	
    QWidget *Central, *MainWidget, *BiasWidget, *EnvironmentWidget;
    QGridLayout *MainLayout, *BiasLayout, *EnvironmentLayout;

    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *); 

  public:
    GUI();
    ~GUI();
    
  private slots:
    void MenuAbout();
};

#endif
