#ifndef EDD_H_SEEN
#define EDD_H_SEEN

#include <QtGui>
 
#include <qwt_plot.h>
#include <qwt_plot_curve.h>
#include <qwt_plot_grid.h>
#include <qwt_plot_zoomer.h>
#include <qwt_plot_panner.h>
#include <qwt_scale_engine.h>
#include <qwt_analog_clock.h>
#include <qwt_scale_widget.h>
#include <qwt_plot_layout.h>
#include <qwt_legend.h>
#include <qwt_legend_item.h>
#include <qwt_symbol.h>

#include <limits.h>
#include <float.h>

#include "dic.hxx"
#include "Evidence.h"

#define SVN_REVISION "$Revision: 142 $"
		  
// General indicator for DIM service
class Edd_Indicator: public QLineEdit, public DimClient {
    Q_OBJECT

    QMenu *Menu;
    QPoint dragStart;
    QwtPlot *LastPlot;
	
    DimStampedInfo *Data;
	
    void mousePressEvent(QMouseEvent *); 
    void mouseReleaseEvent(QMouseEvent *); 
    void mouseMoveEvent(QMouseEvent *); 
	
  public:
    Edd_Indicator(QString, QWidget * = NULL);
    ~Edd_Indicator();

	bool ShowAsTime;
	
  private slots:
	void Update(DimInfo *, int, QString, QByteArray, QString);
    void contextMenuEvent(QContextMenuEvent *);    
    void MenuOpenHistory();
    void MenuCopyService();
};

// Graph class for history display
class Edd_Plot: public QwtPlot, public DimClient {
    Q_OBJECT

    struct PlotItem {
      DimInfo *Data;
      DimInfo *LiveData;
      QwtPlotCurve *Signal;
      int *x;
      double *y;
      int Count;
      double Smallest;
      double Largest;
      QList<struct EvidenceHistoryItem> Live;
    };

    QList<struct PlotItem> Items;
    QMutex Mutex;
    
	QString StatusTip;
	
    QMenu *Menu;
    QAction *YLogAction;
    QAction *NormAction;
    QAction *StyleAction;
    
    QwtPlotPanner *Panner;
    QwtPlotGrid *Grid;
    QwtPlotZoomer *Zoomer;
    QwtLegend *Legend;
    
    void dragEnterEvent(QDragEnterEvent *);
    void dropEvent(QDropEvent *);

  public:
    Edd_Plot(QString = QString(), QWidget * = NULL);
    ~Edd_Plot();
    void AddService(QString);

  private slots:
    void UpdatePlot();
	void Update(DimInfo* Info, int, QString, QByteArray, QString);

    void HandleZoom(const QwtDoubleRect &);
    void contextMenuEvent(QContextMenuEvent *);    
    void MenuZoomOut();
    void MenuSingleTrace();        
    void MenuSaveASCII();
    void MenuSave();
    void MenuPrint();
    void MenuPasteService();
};

// Textout indicator for DIM service
class Edd_Textout: public QTextEdit, public DimClient {
    Q_OBJECT

    DimStampedInfo *Data;

  public:
    Edd_Textout(QString, QWidget * = NULL);
    ~Edd_Textout();
	
	bool Accumulate;
	
  private slots:
	void Update(DimInfo* Info, int, QString, QByteArray, QString);
};

// Main window class
class GUI: public QMainWindow, public DimBrowser, public DimInfo {
    Q_OBJECT

    QwtAnalogClock *Clock;
	
    QWidget *Central, *MainWidget, *BiasWidget, *EnvironmentWidget;
    QGridLayout *MainLayout, *BiasLayout, *EnvironmentLayout;

    QTabWidget *TabWidget;
            
    void closeEvent(QCloseEvent *);
	void infoHandler();
	
  public:
    GUI();
    ~GUI();
    
  private slots:
    void MenuAbout();
    void MenuNewHistory();
	
  signals:
    void YEP(DimInfo *, int, QString = QString(), QByteArray = QByteArray(), QString = QString());
};

#endif
